/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.SlotSharingGroupAssignment;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTag;

public class SlotSharingGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<JobVertexID> ids = new TreeSet<JobVertexID>();
    private final List<SlotTag> tags = new ArrayList<SlotTag>();
    private transient SlotSharingGroupAssignment taskAssignment;
    private final SlotSharingGroupId slotSharingGroupId = new SlotSharingGroupId();
    private ResourceProfile resourceProfile;

    public SlotSharingGroup() {
    }

    public SlotSharingGroup(JobVertexID ... sharedVertices) {
        for (JobVertexID id : sharedVertices) {
            this.ids.add(id);
        }
    }

    public void addVertexToGroup(JobVertexID id) {
        this.ids.add(id);
    }

    public void addTagsToGroup(List<SlotTag> tags) {
        this.tags.addAll(tags);
    }

    public void removeVertexFromGroup(JobVertexID id) {
        this.ids.remove((Object)id);
    }

    public Set<JobVertexID> getJobVertexIds() {
        return Collections.unmodifiableSet(this.ids);
    }

    public List<SlotTag> getTags() {
        return this.tags;
    }

    public SlotSharingGroupId getSlotSharingGroupId() {
        return this.slotSharingGroupId;
    }

    public SlotSharingGroupAssignment getTaskAssignment() {
        if (this.taskAssignment == null) {
            this.taskAssignment = new SlotSharingGroupAssignment();
        }
        return this.taskAssignment;
    }

    public void clearTaskAssignment() {
        if (this.taskAssignment != null && this.taskAssignment.getNumberOfSlots() > 0) {
            throw new IllegalStateException("SlotSharingGroup cannot clear task assignment, group still has allocated resources.");
        }
        this.taskAssignment = null;
    }

    public void setResourceProfile(ResourceProfile resourceProfile) {
        this.resourceProfile = resourceProfile;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public String toString() {
        return "SlotSharingGroup " + this.ids.toString();
    }
}

