/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.failover;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.jobmaster.failover.OperationLog;
import org.apache.flink.runtime.jobmaster.failover.OperationLogStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryOperationLogStore
implements OperationLogStore {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryOperationLogStore.class);
    private static List<OperationLog> operationLogs;
    private int readIndex;

    @VisibleForTesting
    public static void disable() {
        operationLogs = null;
    }

    MemoryOperationLogStore() {
    }

    @Override
    public void start() {
        if (operationLogs == null) {
            operationLogs = new ArrayList<OperationLog>();
        }
        this.readIndex = 0;
    }

    @Override
    public void stop() {
        this.readIndex = 0;
    }

    @Override
    public void clear() {
        if (operationLogs != null) {
            operationLogs.clear();
        }
        this.readIndex = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("All operation logs in memory are cleared.");
        }
    }

    @Override
    public void writeOpLog(@Nonnull OperationLog opLog) {
        if (operationLogs == null) {
            throw new IllegalStateException("Cannot write OpLog into a store before starting it");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing a operation log in memory.");
        }
        operationLogs.add(opLog);
    }

    @Override
    public OperationLog readOpLog() {
        if (operationLogs == null) {
            throw new IllegalStateException("Cannot read OpLog from a store before starting it");
        }
        if (this.readIndex < operationLogs.size()) {
            return operationLogs.get(this.readIndex++);
        }
        return null;
    }
}

