/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSchedulingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PreviousAllocationSchedulingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolConfiguration;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolFactory;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.util.clock.Clock;
import org.apache.flink.runtime.util.clock.SystemClock;

public class DefaultSlotPoolFactory
implements SlotPoolFactory {
    @Nonnull
    private final RpcService rpcService;
    @Nonnull
    private final SchedulingStrategy schedulingStrategy;
    @Nonnull
    private final Clock clock;
    @Nonnull
    private final Time rpcTimeout;
    @Nonnull
    private final Time slotIdleTimeout;
    @Nonnull
    private final Boolean enableSharedSlot;
    private final boolean enableSlotTagMatching;
    private final boolean enableSlotsConverging;

    public DefaultSlotPoolFactory(@Nonnull RpcService rpcService, @Nonnull SchedulingStrategy schedulingStrategy, @Nonnull Clock clock, @Nonnull Time rpcTimeout, @Nonnull Time slotIdleTimeout, @Nonnull Boolean enableSharedSlot, boolean enableSlotTagMatching, boolean enableSlotsConverging) {
        this.rpcService = rpcService;
        this.schedulingStrategy = schedulingStrategy;
        this.clock = clock;
        this.rpcTimeout = rpcTimeout;
        this.slotIdleTimeout = slotIdleTimeout;
        this.enableSharedSlot = enableSharedSlot;
        this.enableSlotTagMatching = enableSlotTagMatching;
        this.enableSlotsConverging = enableSlotsConverging;
    }

    @Override
    @Nonnull
    public SlotPool createSlotPool(@Nonnull JobID jobId) {
        return new SlotPool(this.rpcService, jobId, this.schedulingStrategy, this.clock, this.rpcTimeout, this.slotIdleTimeout, this.enableSharedSlot, this.enableSlotTagMatching, this.enableSlotsConverging);
    }

    public static DefaultSlotPoolFactory fromConfiguration(@Nonnull Configuration configuration, @Nonnull RpcService rpcService) {
        return DefaultSlotPoolFactory.fromConfiguration(new SlotPoolConfiguration(configuration), rpcService);
    }

    public static DefaultSlotPoolFactory fromConfiguration(@Nonnull SlotPoolConfiguration slotPoolConfiguration, @Nonnull RpcService rpcService) {
        Configuration configuration = slotPoolConfiguration.getConfiguration();
        Time rpcTimeout = AkkaUtils.getTimeoutAsTime(configuration);
        Time slotIdleTimeout = Time.milliseconds((long)configuration.getLong(JobManagerOptions.SLOT_IDLE_TIMEOUT));
        SchedulingStrategy schedulingStrategy = DefaultSlotPoolFactory.selectSchedulingStrategy(configuration);
        Boolean enableSharedSlot = configuration.getBoolean(JobManagerOptions.SLOT_ENABLE_SHARED_SLOT);
        return new DefaultSlotPoolFactory(rpcService, schedulingStrategy, SystemClock.getInstance(), rpcTimeout, slotIdleTimeout, enableSharedSlot, slotPoolConfiguration.isEnableSlotTagMatching(), slotPoolConfiguration.isEnableSlotsConverging());
    }

    private static SchedulingStrategy selectSchedulingStrategy(Configuration configuration) {
        if (configuration.getBoolean(CheckpointingOptions.LOCAL_RECOVERY)) {
            return PreviousAllocationSchedulingStrategy.getInstance();
        }
        return LocationPreferenceSchedulingStrategy.getInstance();
    }
}

