/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulingStrategy;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class LocationPreferenceSchedulingStrategy
implements SchedulingStrategy {
    private static final LocationPreferenceSchedulingStrategy INSTANCE = new LocationPreferenceSchedulingStrategy();

    LocationPreferenceSchedulingStrategy() {
    }

    @Override
    @Nullable
    public <IN, OUT> OUT findMatchWithLocality(@Nonnull SlotProfile slotProfile, @Nonnull Stream<IN> candidates, @Nonnull Function<IN, SlotContext> contextExtractor, @Nonnull Predicate<IN> additionalRequirementsFilter, @Nonnull BiFunction<IN, Locality, OUT> resultProducer) {
        Collection<TaskManagerLocation> locationPreferences = slotProfile.getPreferredLocations();
        if (locationPreferences.isEmpty()) {
            return candidates.filter(additionalRequirementsFilter).findFirst().map(result -> resultProducer.apply(result, Locality.UNCONSTRAINED)).orElse(null);
        }
        HashSet<ResourceID> preferredResourceIDs = new HashSet<ResourceID>(locationPreferences.size());
        HashSet<String> preferredFQHostNames = new HashSet<String>(locationPreferences.size());
        for (TaskManagerLocation locationPreference : locationPreferences) {
            preferredResourceIDs.add(locationPreference.getResourceID());
            preferredFQHostNames.add(locationPreference.getFQDNHostname());
        }
        Iterator iterator = candidates.iterator();
        Object matchByHostName = null;
        Object matchByAdditionalRequirements = null;
        while (iterator.hasNext()) {
            Object candidate = iterator.next();
            SlotContext slotContext = contextExtractor.apply(candidate);
            if (preferredResourceIDs.contains(slotContext.getTaskManagerLocation().getResourceID())) {
                if (!additionalRequirementsFilter.test(candidate)) continue;
                return resultProducer.apply(candidate, Locality.LOCAL);
            }
            if (matchByHostName != null) continue;
            if (preferredFQHostNames.contains(slotContext.getTaskManagerLocation().getFQDNHostname())) {
                if (!additionalRequirementsFilter.test(candidate)) continue;
                matchByHostName = candidate;
            }
            if (matchByAdditionalRequirements != null || !additionalRequirementsFilter.test(candidate)) continue;
            matchByAdditionalRequirements = candidate;
        }
        if (matchByHostName != null) {
            return resultProducer.apply(matchByHostName, Locality.HOST_LOCAL);
        }
        if (matchByAdditionalRequirements != null) {
            return resultProducer.apply(matchByAdditionalRequirements, Locality.NON_LOCAL);
        }
        return null;
    }

    public static LocationPreferenceSchedulingStrategy getInstance() {
        return INSTANCE;
    }
}

