/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.TaskManagerResourceDescription;
import org.apache.flink.runtime.messages.webmonitor.JobsOverview;
import org.apache.flink.runtime.resourcemanager.ResourceOverview;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class ClusterOverview
extends JobsOverview {
    private static final long serialVersionUID = -729861859715105265L;
    public static final String FIELD_NAME_TASKMANAGERS = "taskmanagers";
    public static final String FIELD_NAME_SLOTS_TOTAL = "slots-total";
    public static final String FIELD_NAME_SLOTS_AVAILABLE = "slots-available";
    public static final String FIELD_NAME_TOTAL_RESOURCES = "total-resources";
    public static final String FIELD_NAME_AVAILABLE_RESOURCES = "available-resources";
    @JsonProperty(value="taskmanagers")
    private final int numTaskManagersConnected;
    @JsonProperty(value="slots-total")
    private final int numSlotsTotal;
    @JsonProperty(value="slots-available")
    private final int numSlotsAvailable;
    @JsonProperty(value="total-resources")
    private final TaskManagerResourceDescription totalResources;
    @JsonProperty(value="available-resources")
    private final TaskManagerResourceDescription availableResources;

    @JsonCreator
    public ClusterOverview(@JsonProperty(value="taskmanagers") int numTaskManagersConnected, @JsonProperty(value="slots-total") int numSlotsTotal, @JsonProperty(value="slots-available") int numSlotsAvailable, @JsonProperty(value="total-resources") TaskManagerResourceDescription totalResources, @JsonProperty(value="available-resources") TaskManagerResourceDescription availableResources, @JsonProperty(value="jobs-running") int numJobsRunningOrPending, @JsonProperty(value="jobs-finished") int numJobsFinished, @JsonProperty(value="jobs-cancelled") int numJobsCancelled, @JsonProperty(value="jobs-failed") int numJobsFailed) {
        super(numJobsRunningOrPending, numJobsFinished, numJobsCancelled, numJobsFailed);
        this.numTaskManagersConnected = numTaskManagersConnected;
        this.numSlotsTotal = numSlotsTotal;
        this.numSlotsAvailable = numSlotsAvailable;
        this.totalResources = totalResources;
        this.availableResources = availableResources;
    }

    @Deprecated
    public ClusterOverview(int numTaskManagersConnected, int numSlotsTotal, int numSlotsAvailable, JobsOverview jobs1, JobsOverview jobs2) {
        super(jobs1, jobs2);
        this.numTaskManagersConnected = numTaskManagersConnected;
        this.numSlotsTotal = numSlotsTotal;
        this.numSlotsAvailable = numSlotsAvailable;
        this.totalResources = TaskManagerResourceDescription.fromResourceProfile(ResourceProfile.UNKNOWN);
        this.availableResources = TaskManagerResourceDescription.fromResourceProfile(ResourceProfile.UNKNOWN);
    }

    public ClusterOverview(ResourceOverview resourceOverview, JobsOverview jobsOverview) {
        this(resourceOverview.getNumberTaskManagers(), resourceOverview.getNumberRegisteredSlots(), resourceOverview.getNumberFreeSlots(), TaskManagerResourceDescription.fromResourceProfile(resourceOverview.getTotalResources()), TaskManagerResourceDescription.fromResourceProfile(resourceOverview.getAvailableResources()), jobsOverview.getNumJobsRunningOrPending(), jobsOverview.getNumJobsFinished(), jobsOverview.getNumJobsCancelled(), jobsOverview.getNumJobsFailed());
    }

    public int getNumTaskManagersConnected() {
        return this.numTaskManagersConnected;
    }

    public int getNumSlotsTotal() {
        return this.numSlotsTotal;
    }

    public int getNumSlotsAvailable() {
        return this.numSlotsAvailable;
    }

    public TaskManagerResourceDescription getTotalResources() {
        return this.totalResources;
    }

    public TaskManagerResourceDescription getAvailableResources() {
        return this.availableResources;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClusterOverview) {
            ClusterOverview that = (ClusterOverview)obj;
            return this.numTaskManagersConnected == that.numTaskManagersConnected && this.numSlotsTotal == that.numSlotsTotal && this.numSlotsAvailable == that.numSlotsAvailable && this.getNumJobsRunningOrPending() == that.getNumJobsRunningOrPending() && this.getNumJobsFinished() == that.getNumJobsFinished() && this.getNumJobsCancelled() == that.getNumJobsCancelled() && this.getNumJobsFailed() == that.getNumJobsFailed();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.numTaskManagersConnected;
        result = 31 * result + this.numSlotsTotal;
        result = 31 * result + this.numSlotsAvailable;
        return result;
    }

    @Override
    public String toString() {
        return "StatusOverview {numTaskManagersConnected=" + this.numTaskManagersConnected + ", numSlotsTotal=" + this.numSlotsTotal + ", numSlotsAvailable=" + this.numSlotsAvailable + ", numJobsRunningOrPending=" + this.getNumJobsRunningOrPending() + ", numJobsFinished=" + this.getNumJobsFinished() + ", numJobsCancelled=" + this.getNumJobsCancelled() + ", numJobsFailed=" + this.getNumJobsFailed() + '}';
    }
}

