/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.InternalResultPartition;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.metrics.SumAndCount;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.taskmanager.Task;

public class TaskIOMetricGroup
extends ProxyMetricGroup<TaskMetricGroup> {
    private final Counter numBytesOut = this.counter("numBytesOut");
    private final Counter numBuffersOut = this.counter("numBuffersOut");
    private final Counter numBytesInLocal = this.counter("numBytesInLocal");
    private final Counter numBytesInRemote = this.counter("numBytesInRemote");
    private final Counter numRecordsSent;
    private final Counter numRecordsReceived;
    private final SumCounter numRecordsIn;
    private final SumCounter numRecordsOut;
    private final SumAndCount nsWaitBufferTime;
    private final Meter numBytesInRateLocal;
    private final Meter numBytesInRateRemote;
    private final Meter numBytesOutRate = this.meter("numBytesOutPerSecond", new MeterView(this.numBytesOut, 60));
    private final Meter numRecordsInRate;
    private final Meter numRecordsOutRate;

    public TaskIOMetricGroup(TaskMetricGroup parent) {
        super(parent);
        this.numBytesInRateLocal = this.meter("numBytesInLocalPerSecond", new MeterView(this.numBytesInLocal, 60));
        this.numBytesInRateRemote = this.meter("numBytesInRemotePerSecond", new MeterView(this.numBytesInRemote, 60));
        this.numRecordsIn = this.counter("numRecordsIn", new SumCounter());
        this.numRecordsOut = this.counter("numRecordsOut", new SumCounter());
        this.numRecordsInRate = this.meter("numRecordsInPerSecond", new MeterView((Counter)this.numRecordsIn, 60));
        this.numRecordsOutRate = this.meter("numRecordsOutPerSecond", new MeterView((Counter)this.numRecordsOut, 60));
        this.nsWaitBufferTime = new SumAndCount("waitOutput", parent);
        this.numRecordsSent = this.counter("numRecordsSent");
        this.numRecordsReceived = this.counter("numRecordsReceived");
    }

    public IOMetrics createSnapshot() {
        return new IOMetrics(this.numRecordsInRate, this.numRecordsOutRate, this.numBytesInRateLocal, this.numBytesInRateRemote, this.numBytesOutRate);
    }

    public Counter getNumBytesOutCounter() {
        return this.numBytesOut;
    }

    public Counter getNumBuffersOutCounter() {
        return this.numBuffersOut;
    }

    public Counter getNumBytesInLocalCounter() {
        return this.numBytesInLocal;
    }

    public Counter getNumBytesInRemoteCounter() {
        return this.numBytesInRemote;
    }

    public Counter getNumRecordsInCounter() {
        return this.numRecordsIn;
    }

    public Counter getNumRecordsOutCounter() {
        return this.numRecordsOut;
    }

    public Meter getNumBytesInLocalRateMeter() {
        return this.numBytesInRateLocal;
    }

    public Meter getNumBytesInRemoteRateMeter() {
        return this.numBytesInRateRemote;
    }

    public Meter getNumBytesOutRateMeter() {
        return this.numBytesOutRate;
    }

    public Counter getNumRecordsSent() {
        return this.numRecordsSent;
    }

    public void initializeBufferMetrics(Task task) {
        MetricGroup buffers = this.addGroup("buffers");
        buffers.gauge("inputQueueLength", (Gauge)new InputBuffersGauge(task));
        buffers.gauge("outputQueueLength", (Gauge)new OutputBuffersGauge(task));
        buffers.gauge("inPoolUsage", (Gauge)new InputBufferPoolUsageGauge(task));
        buffers.gauge("outPoolUsage", (Gauge)new OutputBufferPoolUsageGauge(task));
    }

    public Counter getNumRecordsReceived() {
        return this.numRecordsReceived;
    }

    public void reuseRecordsInputCounter(Counter numRecordsInCounter) {
        this.numRecordsIn.addCounter(numRecordsInCounter);
    }

    public void reuseRecordsOutputCounter(Counter numRecordsOutCounter) {
        this.numRecordsOut.addCounter(numRecordsOutCounter);
    }

    public SumAndCount getNsWaitBufferTime() {
        return this.nsWaitBufferTime;
    }

    private static class SumCounter
    extends SimpleCounter {
        private final List<Counter> internalCounters = new ArrayList<Counter>();

        SumCounter() {
        }

        public void addCounter(Counter toAdd) {
            this.internalCounters.add(toAdd);
        }

        public long getCount() {
            long sum = super.getCount();
            for (Counter counter : this.internalCounters) {
                sum += counter.getCount();
            }
            return sum;
        }
    }

    private static final class OutputBufferPoolUsageGauge
    implements Gauge<Float> {
        private final Task task;

        public OutputBufferPoolUsageGauge(Task task) {
            this.task = task;
        }

        public Float getValue() {
            float maxUsage = 0.0f;
            for (InternalResultPartition internalResultPartition : this.task.getInternalPartitions()) {
                float currentPoolUsage;
                BufferPool bufferPool = internalResultPartition.getBufferPool();
                int usedBuffers = bufferPool.bestEffortGetNumOfUsedBuffers();
                int bufferPoolSize = bufferPool.getNumBuffers();
                if (bufferPoolSize == 0 || !((currentPoolUsage = (float)usedBuffers / (float)bufferPoolSize) > maxUsage)) continue;
                maxUsage = currentPoolUsage;
            }
            return Float.valueOf(maxUsage);
        }
    }

    private static final class InputBufferPoolUsageGauge
    implements Gauge<Float> {
        private final Task task;

        public InputBufferPoolUsageGauge(Task task) {
            this.task = task;
        }

        public Float getValue() {
            float maxUsage = 0.0f;
            for (SingleInputGate inputGate : this.task.getAllInputGates()) {
                float currentPoolUsage;
                BufferPool bufferPool = inputGate.getBufferPool();
                int usedBuffers = bufferPool.bestEffortGetNumOfUsedBuffers();
                int bufferPoolSize = bufferPool.getNumBuffers();
                if (bufferPoolSize == 0 || !((currentPoolUsage = (float)usedBuffers / (float)bufferPoolSize) > maxUsage)) continue;
                maxUsage = currentPoolUsage;
            }
            return Float.valueOf(maxUsage);
        }
    }

    private static final class OutputBuffersGauge
    implements Gauge<Integer> {
        private final Task task;

        public OutputBuffersGauge(Task task) {
            this.task = task;
        }

        public Integer getValue() {
            int totalBuffers = 0;
            for (InternalResultPartition producedPartition : this.task.getInternalPartitions()) {
                totalBuffers += producedPartition.getNumberOfQueuedBuffers();
            }
            return totalBuffers;
        }
    }

    private static final class InputBuffersGauge
    implements Gauge<Integer> {
        private final Task task;

        public InputBuffersGauge(Task task) {
            this.task = task;
        }

        public Integer getValue() {
            int totalBuffers = 0;
            for (SingleInputGate inputGate : this.task.getAllInputGates()) {
                totalBuffers += inputGate.getNumberOfQueuedBuffers();
            }
            return totalBuffers;
        }
    }
}

