/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class TaskManagerMetricGroup
extends ComponentMetricGroup<TaskManagerMetricGroup> {
    private final Map<JobID, TaskManagerJobMetricGroup> jobs = new HashMap<JobID, TaskManagerJobMetricGroup>();
    private final String hostname;
    private final String taskManagerId;
    private ScheduledExecutorService scheduledExecutorService;

    public TaskManagerMetricGroup(MetricRegistry registry, String hostname, String taskManagerId) {
        super(registry, registry.getScopeFormats().getTaskManagerFormat().formatScope(hostname, taskManagerId), null);
        this.hostname = hostname;
        this.taskManagerId = taskManagerId;
    }

    public String hostname() {
        return this.hostname;
    }

    public String taskManagerId() {
        return this.taskManagerId;
    }

    @Override
    protected QueryScopeInfo.TaskManagerQueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return new QueryScopeInfo.TaskManagerQueryScopeInfo(this.taskManagerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskMetricGroup addTaskForJob(JobID jobId, String jobName, JobVertexID jobVertexId, ExecutionAttemptID executionAttemptId, String taskName, int subtaskIndex, int attemptNumber) {
        TaskManagerJobMetricGroup currentJobGroup;
        TaskMetricGroup taskGroup;
        Preconditions.checkNotNull((Object)jobId);
        String resolvedJobName = jobName == null || jobName.isEmpty() ? jobId.toString() : jobName;
        do {
            TaskManagerMetricGroup taskManagerMetricGroup = this;
            synchronized (taskManagerMetricGroup) {
                currentJobGroup = this.jobs.get(jobId);
                if (currentJobGroup == null || currentJobGroup.isClosed()) {
                    currentJobGroup = new TaskManagerJobMetricGroup(this.registry, this, jobId, resolvedJobName);
                    this.jobs.put(jobId, currentJobGroup);
                }
            }
        } while ((taskGroup = currentJobGroup.addTask(jobVertexId, executionAttemptId, taskName, subtaskIndex, attemptNumber)) == null);
        return taskGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobMetricsGroup(JobID jobId, TaskManagerJobMetricGroup group) {
        if (jobId == null || group == null || !group.isClosed()) {
            return;
        }
        TaskManagerMetricGroup taskManagerMetricGroup = this;
        synchronized (taskManagerMetricGroup) {
            TaskManagerJobMetricGroup containedGroup = this.jobs.remove(jobId);
            if (containedGroup != null && containedGroup != group) {
                this.jobs.put(jobId, containedGroup);
            }
        }
    }

    public int numRegisteredJobMetricGroups() {
        return this.jobs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledExecutorService getMetricExecutor() {
        TaskManagerMetricGroup taskManagerMetricGroup = this;
        synchronized (taskManagerMetricGroup) {
            if (this.scheduledExecutorService == null) {
                this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ExecutorThreadFactory("Flink-TaskManager-Metric-Executor"));
            }
            return this.scheduledExecutorService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        TaskManagerMetricGroup taskManagerMetricGroup = this;
        synchronized (taskManagerMetricGroup) {
            if (this.scheduledExecutorService != null) {
                ExecutorUtils.gracefulShutdown((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{this.scheduledExecutorService});
            }
        }
        super.close();
    }

    @Override
    protected void putVariables(Map<String, String> variables) {
        variables.put(ScopeFormat.SCOPE_HOST, this.hostname);
        variables.put(ScopeFormat.SCOPE_TASKMANAGER_ID, this.taskManagerId);
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return this.jobs.values();
    }

    @Override
    protected String getGroupName(CharacterFilter filter) {
        return "taskmanager";
    }
}

