/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.operators.sort.ChannelDeleteRegistry;
import org.apache.flink.runtime.operators.sort.MergeIterator;
import org.apache.flink.runtime.operators.sort.RecordComparisonMerger;
import org.apache.flink.runtime.operators.sort.SortedDataFile;
import org.apache.flink.runtime.operators.sort.SortedDataFileFactory;
import org.apache.flink.runtime.operators.sort.WriterCollector;
import org.apache.flink.runtime.util.KeyGroupedIterator;
import org.apache.flink.runtime.util.NonReusingKeyGroupedIterator;
import org.apache.flink.runtime.util.ReusingKeyGroupedIterator;

public class CombiningRecordComparisonMerger<T>
extends RecordComparisonMerger<T> {
    private final GroupCombineFunction<T, T> combineStub;

    public CombiningRecordComparisonMerger(GroupCombineFunction<T, T> combineStub, SortedDataFileFactory<T> sortedDataFileFactory, IOManager ioManager, TypeSerializer<T> typeSerializer, TypeComparator<T> typeComparator, int maxFanIn, boolean enableObjectReuse) {
        super(sortedDataFileFactory, ioManager, typeSerializer, typeComparator, maxFanIn, enableObjectReuse);
        this.combineStub = combineStub;
    }

    @Override
    protected SortedDataFile<T> mergeToNewFile(List<SortedDataFile<T>> channelIDs, List<List<MemorySegment>> readBuffers, List<MemorySegment> writeBuffers, ChannelDeleteRegistry<T> channelDeleteRegistry) throws IOException {
        ArrayList<FileIOChannel> channelAccesses = new ArrayList<FileIOChannel>(channelIDs.size());
        MergeIterator<T> mergeIterator = this.getMergingIteratorWithSegmentedMemory(channelIDs, readBuffers, channelAccesses, null, channelDeleteRegistry);
        SortedDataFile output = this.sortedDataFileFactory.createFile(writeBuffers);
        channelDeleteRegistry.registerChannelToBeDelete(output.getChannelID());
        channelDeleteRegistry.registerOpenChannel(output.getWriteChannel());
        WriterCollector collector = new WriterCollector(output);
        GroupCombineFunction<T, T> combineStub = this.combineStub;
        try {
            KeyGroupedIterator<T> groupedIter;
            if (this.objectReuseEnabled) {
                groupedIter = new ReusingKeyGroupedIterator<T>(mergeIterator, this.typeSerializer, this.typeComparator);
                while (((ReusingKeyGroupedIterator)groupedIter).nextKey()) {
                    combineStub.combine((Iterable)((ReusingKeyGroupedIterator)groupedIter).getValues(), collector);
                }
            } else {
                groupedIter = new NonReusingKeyGroupedIterator<T>(mergeIterator, this.typeComparator);
                while (((NonReusingKeyGroupedIterator)groupedIter).nextKey()) {
                    combineStub.combine((Iterable)((NonReusingKeyGroupedIterator)groupedIter).getValues(), collector);
                }
            }
        }
        catch (Exception e) {
            throw new IOException("An error occurred in the combiner user code.");
        }
        output.finishWriting();
        channelDeleteRegistry.unregisterOpenChannel(output.getWriteChannel());
        for (int i = 0; i < channelAccesses.size(); ++i) {
            FileIOChannel access = (FileIOChannel)channelAccesses.get(i);
            this.ioManager.deleteChannel(access.getChannelID());
            channelDeleteRegistry.unregisterOpenChannel(access);
        }
        return output;
    }
}

