/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import org.apache.flink.util.Preconditions;

public class DataFileInfo<T> {
    private final int mergeRound;
    private final long fileLength;
    private final int numSubpartitions;
    private final T dataFile;

    public DataFileInfo(long fileLength, int mergeRound, int numSubpartitions, T dataFile) {
        Preconditions.checkArgument((fileLength > 0L ? 1 : 0) != 0, (Object)("Illegal file length: " + fileLength));
        Preconditions.checkArgument((mergeRound >= 0 ? 1 : 0) != 0, (Object)("Illegal merge round: " + mergeRound));
        Preconditions.checkArgument((numSubpartitions > 0 ? 1 : 0) != 0, (Object)("Illegal number of subpartitions: " + numSubpartitions));
        this.fileLength = fileLength;
        this.mergeRound = mergeRound;
        this.numSubpartitions = numSubpartitions;
        this.dataFile = Preconditions.checkNotNull(dataFile);
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public int getMergeRound() {
        return this.mergeRound;
    }

    public int getNumSubpartitions() {
        return this.numSubpartitions;
    }

    public T getDataFile() {
        return this.dataFile;
    }
}

