/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.runtime.operators.sort.DataFileInfo;
import org.apache.flink.runtime.operators.sort.MergePolicy;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileMergePolicy<T>
implements MergePolicy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFileMergePolicy.class);
    private final int mergeFactor;
    private final boolean mergeToOneFile;
    private final boolean enableAsyncMerging;
    private List<LinkedList<DataFileInfo<T>>> layeredDataFiles = new ArrayList<LinkedList<DataFileInfo<T>>>();
    private boolean isFinalMergeStarted = false;

    public DefaultFileMergePolicy(int mergeFactor, boolean enableAsyncMerging, boolean mergeToOneFile) {
        Preconditions.checkArgument((mergeFactor >= 2 ? 1 : 0) != 0, (Object)("Illegal merge factor: " + mergeFactor));
        this.mergeFactor = mergeFactor;
        this.enableAsyncMerging = enableAsyncMerging;
        this.mergeToOneFile = mergeToOneFile;
    }

    @Override
    public void addNewCandidate(DataFileInfo<T> dataFileInfo) {
        if (this.isFinalMergeStarted) {
            Preconditions.checkState((this.layeredDataFiles.size() == 1 ? 1 : 0) != 0, (Object)("Illegal layer size: " + this.layeredDataFiles.size()));
            this.layeredDataFiles.get(0).addLast(dataFileInfo);
        } else {
            int mergeRound = dataFileInfo.getMergeRound();
            Preconditions.checkArgument((this.layeredDataFiles.size() >= mergeRound ? 1 : 0) != 0, (Object)("Illegal merge round: (" + mergeRound + " " + this.layeredDataFiles.size() + ")"));
            if (this.layeredDataFiles.size() == mergeRound) {
                LinkedList dataFiles = new LinkedList();
                this.layeredDataFiles.add(dataFiles);
            }
            this.layeredDataFiles.get(mergeRound).addLast(dataFileInfo);
        }
    }

    @Override
    public void startFinalMerge() {
        Preconditions.checkState((!this.isFinalMergeStarted ? 1 : 0) != 0, (Object)"Final merge has been started");
        this.isFinalMergeStarted = true;
        for (int i = 1; i < this.layeredDataFiles.size(); ++i) {
            this.layeredDataFiles.get(0).addAll((Collection)this.layeredDataFiles.get(i));
        }
        if (this.layeredDataFiles.size() > 1) {
            this.layeredDataFiles = this.layeredDataFiles.subList(0, 1);
        }
    }

    @Override
    public List<DataFileInfo<T>> selectMergeCandidates(int numMergeReadMemory) {
        int numFileHandles = Math.min(this.mergeFactor, numMergeReadMemory / 2);
        ArrayList<DataFileInfo<T>> candidates = new ArrayList<DataFileInfo<T>>(numFileHandles);
        if (this.layeredDataFiles.isEmpty()) {
            Preconditions.checkState((boolean)this.isFinalMergeStarted, (Object)"Final merge should have been started.");
            return null;
        }
        if (this.isFinalMergeStarted) {
            LinkedList<DataFileInfo<T>> dataFiles = this.layeredDataFiles.get(0);
            Preconditions.checkArgument((numMergeReadMemory >= 4 || dataFiles.size() <= 1 ? 1 : 0) != 0, (Object)("At least 4 read buffers is needed, but actual is " + numMergeReadMemory));
            dataFiles.sort(new FileLengthComparator());
            if (dataFiles.size() > this.mergeFactor && !this.mergeToOneFile) {
                numFileHandles = Math.min(numFileHandles, dataFiles.size() - this.mergeFactor + 1);
            } else if (this.mergeToOneFile && dataFiles.size() > 1) {
                numFileHandles = dataFiles.size() <= numFileHandles ? dataFiles.size() : Math.min(numFileHandles, dataFiles.size() - numFileHandles + 1);
            } else {
                return null;
            }
            for (int i = 0; i < numFileHandles; ++i) {
                candidates.add(dataFiles.removeFirst());
            }
            return candidates;
        }
        if (this.enableAsyncMerging) {
            Preconditions.checkArgument((numMergeReadMemory >= 4 ? 1 : 0) != 0, (Object)("At least 4 read buffers is needed, but actual is " + numMergeReadMemory));
            for (LinkedList<DataFileInfo<T>> dataFiles : this.layeredDataFiles) {
                if (dataFiles.size() <= this.mergeFactor) continue;
                for (int i = 0; i < numFileHandles; ++i) {
                    candidates.add(dataFiles.removeFirst());
                }
                return candidates;
            }
        }
        return null;
    }

    @Override
    public List<T> getFinalMergeResult() {
        Preconditions.checkState((this.layeredDataFiles.size() <= 1 ? 1 : 0) != 0, (Object)("Illegal merge state: " + this.layeredDataFiles.size()));
        ArrayList dataFiles = new ArrayList();
        if (this.layeredDataFiles.size() > 0) {
            for (DataFileInfo dataFileInfo : this.layeredDataFiles.get(0)) {
                dataFiles.add(dataFileInfo.getDataFile());
            }
        }
        return dataFiles;
    }

    private static class FileLengthComparator<T>
    implements Comparator<DataFileInfo<T>> {
        private FileLengthComparator() {
        }

        @Override
        public int compare(DataFileInfo<T> file1, DataFileInfo<T> file2) {
            if (file1.getFileLength() == file2.getFileLength()) {
                return 0;
            }
            return file1.getFileLength() >= file2.getFileLength() ? 1 : -1;
        }
    }
}

