/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.plugable;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class CopySerializationDelegate<T>
implements IOReadableWritable {
    private DataInputView inputView;
    private final TypeSerializer<T> serializer;

    public CopySerializationDelegate(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public DataInputView getInputView() {
        return this.inputView;
    }

    public void setInputView(DataInputView inputView) {
        this.inputView = inputView;
    }

    public void write(DataOutputView out) throws IOException {
        this.serializer.copy(this.inputView, out);
    }

    public void read(DataInputView in) throws IOException {
        throw new IllegalStateException("Deserialization method called on CopySerializationDelegate.");
    }
}

