/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTag;
import org.apache.flink.util.Preconditions;

public class SlotRequest
implements Serializable {
    private static final long serialVersionUID = -6586877187990445986L;
    private final JobID jobId;
    private final AllocationID allocationId;
    private final ResourceProfile resourceProfile;
    private final String targetAddress;
    private final List<SlotTag> tags;

    public SlotRequest(JobID jobId, AllocationID allocationId, ResourceProfile resourceProfile, String targetAddress) {
        this(jobId, allocationId, resourceProfile, targetAddress, Collections.emptyList());
    }

    public SlotRequest(JobID jobId, AllocationID allocationId, ResourceProfile resourceProfile, String targetAddress, List<SlotTag> tags) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.allocationId = (AllocationID)((Object)Preconditions.checkNotNull((Object)((Object)allocationId)));
        this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile);
        this.targetAddress = (String)Preconditions.checkNotNull((Object)targetAddress);
        this.tags = (List)Preconditions.checkNotNull(tags);
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public String getTargetAddress() {
        return this.targetAddress;
    }

    public List<SlotTag> getTags() {
        return this.tags;
    }
}

