/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.placementconstraint;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTagScope;

public class SlotTag
implements Serializable {
    private final String tagName;
    private final JobID jobId;

    public SlotTag(String tagName, JobID jobId) {
        this.tagName = tagName;
        this.jobId = jobId;
    }

    public String getTagName() {
        return this.tagName;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public boolean match(SlotTag tag, SlotTagScope scope) {
        switch (scope) {
            case JOB: {
                return this.jobId.equals((Object)tag.getJobId()) && this.tagName.equals(tag.getTagName());
            }
            case FLINK: {
                return this.tagName.equals(tag.getTagName());
            }
        }
        throw new RuntimeException("Unknown slot tag scope {}.");
    }

    public boolean match(SlotTag tag) {
        return this.match(tag, SlotTagScope.JOB);
    }

    public boolean equals(Object obj) {
        SlotTag tag = (SlotTag)obj;
        return this.tagName.equals(tag.tagName) && this.jobId.equals((Object)tag.jobId);
    }

    public String toString() {
        return "tag(" + this.jobId + ", " + this.tagName + ")";
    }

    public int hashCode() {
        return Objects.hash(this.tagName, this.jobId);
    }
}

