/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import akka.pattern.AskTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.clusterframework.types.TaskManagerSlot;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.SlotRequest;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.resourcemanager.placementconstraint.PlacementConstraint;
import org.apache.flink.runtime.resourcemanager.placementconstraint.PlacementConstraintManager;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTag;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingSlotRequest;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceActions;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerException;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerRegistration;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.exceptions.SlotAllocationException;
import org.apache.flink.runtime.taskexecutor.exceptions.SlotOccupiedException;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotManager
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SlotManager.class);
    private final ScheduledExecutor scheduledExecutor;
    private final Time taskManagerRequestTimeout;
    private final Time slotRequestTimeout;
    private final Time taskManagerTimeout;
    private final Time taskManagerFastTimeout;
    private final Time taskManagerCheckerInitialDelay;
    protected final HashMap<SlotID, TaskManagerSlot> slots;
    protected final LinkedHashMap<SlotID, TaskManagerSlot> freeSlots;
    protected final HashMap<InstanceID, TaskManagerRegistration> taskManagerRegistrations;
    private final HashMap<AllocationID, SlotID> fulfilledSlotRequests;
    protected final HashMap<AllocationID, PendingSlotRequest> pendingSlotRequests;
    protected final HashMap<AllocationID, List<SlotTag>> allocationIdTags;
    private ResourceManagerId resourceManagerId;
    private Executor mainThreadExecutor;
    private ResourceActions resourceActions;
    private ScheduledFuture<?> taskManagerTimeoutCheck;
    private ScheduledFuture<?> slotRequestTimeoutCheck;
    private boolean started;
    private boolean tmFastTimeout;
    private SlotListener slotListener;
    protected PlacementConstraintManager placementConstraintManager;

    public SlotManager(ScheduledExecutor scheduledExecutor, Time taskManagerRequestTimeout, Time slotRequestTimeout, Time taskManagerTimeout) {
        this(scheduledExecutor, taskManagerRequestTimeout, slotRequestTimeout, taskManagerTimeout, Time.milliseconds((long)0L));
    }

    public SlotManager(ScheduledExecutor scheduledExecutor, Time taskManagerRequestTimeout, Time slotRequestTimeout, Time taskManagerTimeout, Time taskManagerCheckerInitialDelay) {
        this(scheduledExecutor, taskManagerRequestTimeout, slotRequestTimeout, taskManagerTimeout, Time.milliseconds((long)0L), taskManagerCheckerInitialDelay);
    }

    public SlotManager(ScheduledExecutor scheduledExecutor, Time taskManagerRequestTimeout, Time slotRequestTimeout, Time taskManagerTimeout, Time taskManagerFastTimeout, Time taskManagerCheckerInitialDelay) {
        this.scheduledExecutor = (ScheduledExecutor)Preconditions.checkNotNull((Object)scheduledExecutor);
        this.taskManagerRequestTimeout = (Time)Preconditions.checkNotNull((Object)taskManagerRequestTimeout);
        this.slotRequestTimeout = (Time)Preconditions.checkNotNull((Object)slotRequestTimeout);
        this.taskManagerTimeout = (Time)Preconditions.checkNotNull((Object)taskManagerTimeout);
        this.taskManagerFastTimeout = (Time)Preconditions.checkNotNull((Object)taskManagerFastTimeout);
        this.taskManagerCheckerInitialDelay = taskManagerCheckerInitialDelay;
        this.slots = new HashMap(16);
        this.freeSlots = new LinkedHashMap(16);
        this.taskManagerRegistrations = new HashMap(4);
        this.fulfilledSlotRequests = new HashMap(16);
        this.pendingSlotRequests = new HashMap(16);
        this.allocationIdTags = new HashMap(16);
        this.resourceManagerId = null;
        this.resourceActions = null;
        this.mainThreadExecutor = null;
        this.taskManagerTimeoutCheck = null;
        this.slotRequestTimeoutCheck = null;
        this.placementConstraintManager = new PlacementConstraintManager();
        this.started = false;
    }

    public int getNumberRegisteredSlots() {
        return this.slots.size();
    }

    public int getNumberRegisteredSlotsOf(InstanceID instanceId) {
        TaskManagerRegistration taskManagerRegistration = this.taskManagerRegistrations.get((Object)instanceId);
        if (taskManagerRegistration != null) {
            return taskManagerRegistration.getNumberRegisteredSlots();
        }
        return 0;
    }

    public int getNumberFreeSlots() {
        return this.freeSlots.size();
    }

    public int getNumberFreeSlotsOf(InstanceID instanceId) {
        TaskManagerRegistration taskManagerRegistration = this.taskManagerRegistrations.get((Object)instanceId);
        if (taskManagerRegistration != null) {
            return taskManagerRegistration.getNumberFreeSlots();
        }
        return 0;
    }

    public ResourceProfile getTotalResource() {
        ResourceProfile totalResources = new ResourceProfile(ResourceProfile.EMTPY);
        for (Map.Entry<SlotID, TaskManagerSlot> entry : this.slots.entrySet()) {
            if (entry.getValue().getResourceProfile().equals(ResourceProfile.UNKNOWN)) continue;
            totalResources.addTo(entry.getValue().getResourceProfile());
        }
        return totalResources;
    }

    public ResourceProfile getAvailableResource() {
        ResourceProfile availableResources = new ResourceProfile(ResourceProfile.EMTPY);
        for (Map.Entry<SlotID, TaskManagerSlot> entry : this.slots.entrySet()) {
            if (entry.getValue().getState() != TaskManagerSlot.State.FREE || entry.getValue().getResourceProfile().equals(ResourceProfile.UNKNOWN)) continue;
            availableResources.addTo(entry.getValue().getResourceProfile());
        }
        return availableResources;
    }

    public ResourceProfile getTotalResourceOf(ResourceID resourceID) {
        ResourceProfile totalResources = new ResourceProfile(ResourceProfile.EMTPY);
        for (Map.Entry<SlotID, TaskManagerSlot> entry : this.slots.entrySet()) {
            if (!entry.getKey().getResourceID().equals(resourceID) || entry.getValue().getResourceProfile().equals(ResourceProfile.UNKNOWN)) continue;
            totalResources.addTo(entry.getValue().getResourceProfile());
        }
        return totalResources;
    }

    public ResourceProfile getAvailableResourceOf(ResourceID resourceID) {
        ResourceProfile availableResources = new ResourceProfile(ResourceProfile.EMTPY);
        for (Map.Entry<SlotID, TaskManagerSlot> entry : this.slots.entrySet()) {
            if (entry.getValue().getState() != TaskManagerSlot.State.FREE || !entry.getKey().getResourceID().equals(resourceID) || entry.getValue().getResourceProfile().equals(ResourceProfile.UNKNOWN)) continue;
            availableResources.addTo(entry.getValue().getResourceProfile());
        }
        return availableResources;
    }

    public int getNumberPendingSlotRequests() {
        return this.pendingSlotRequests.size();
    }

    public void setSlotListener(SlotListener slotListener) {
        this.slotListener = slotListener;
    }

    public void start(ResourceManagerId newResourceManagerId, Executor newMainThreadExecutor, ResourceActions newResourceActions) {
        LOG.info("Starting the SlotManager.");
        this.resourceManagerId = (ResourceManagerId)((Object)Preconditions.checkNotNull((Object)((Object)newResourceManagerId)));
        this.mainThreadExecutor = (Executor)Preconditions.checkNotNull((Object)newMainThreadExecutor);
        this.resourceActions = (ResourceActions)Preconditions.checkNotNull((Object)newResourceActions);
        this.started = true;
        this.tmFastTimeout = false;
        this.taskManagerTimeoutCheck = this.scheduledExecutor.scheduleWithFixedDelay(() -> this.mainThreadExecutor.execute(() -> this.checkTaskManagerTimeouts(false)), this.taskManagerCheckerInitialDelay.toMilliseconds(), this.taskManagerTimeout.toMilliseconds(), TimeUnit.MILLISECONDS);
        this.slotRequestTimeoutCheck = this.scheduledExecutor.scheduleWithFixedDelay(() -> this.mainThreadExecutor.execute(() -> this.checkSlotRequestTimeouts()), 0L, this.slotRequestTimeout.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public void suspend() {
        LOG.info("Suspending the SlotManager.");
        if (this.taskManagerTimeoutCheck != null) {
            this.taskManagerTimeoutCheck.cancel(false);
            this.taskManagerTimeoutCheck = null;
        }
        if (this.slotRequestTimeoutCheck != null) {
            this.slotRequestTimeoutCheck.cancel(false);
            this.slotRequestTimeoutCheck = null;
        }
        for (PendingSlotRequest pendingSlotRequest : this.pendingSlotRequests.values()) {
            this.cancelPendingSlotRequest(pendingSlotRequest);
        }
        this.pendingSlotRequests.clear();
        ArrayList<InstanceID> registeredTaskManagers = new ArrayList<InstanceID>(this.taskManagerRegistrations.keySet());
        for (InstanceID registeredTaskManager : registeredTaskManagers) {
            this.unregisterTaskManager(registeredTaskManager);
        }
        this.resourceManagerId = null;
        this.resourceActions = null;
        this.started = false;
    }

    @Override
    public void close() throws Exception {
        LOG.info("Closing the SlotManager.");
        this.suspend();
    }

    public boolean registerSlotRequest(SlotRequest slotRequest) throws SlotManagerException {
        this.checkInit();
        if (this.checkDuplicateRequest(slotRequest.getAllocationId())) {
            LOG.debug("Ignoring a duplicate slot request with allocation id {}.", (Object)slotRequest.getAllocationId());
            return false;
        }
        PendingSlotRequest pendingSlotRequest = new PendingSlotRequest(slotRequest);
        this.pendingSlotRequests.put(slotRequest.getAllocationId(), pendingSlotRequest);
        this.allocationIdTags.put(slotRequest.getAllocationId(), slotRequest.getTags());
        try {
            this.internalRequestSlot(pendingSlotRequest);
        }
        catch (ResourceManagerException e) {
            this.pendingSlotRequests.remove((Object)slotRequest.getAllocationId());
            this.allocationIdTags.remove((Object)slotRequest.getAllocationId());
            throw new SlotManagerException("Could not fulfill slot request " + (Object)((Object)slotRequest.getAllocationId()) + '.', e);
        }
        return true;
    }

    public boolean unregisterSlotRequest(AllocationID allocationId) {
        this.checkInit();
        PendingSlotRequest pendingSlotRequest = this.pendingSlotRequests.remove((Object)allocationId);
        if (null != pendingSlotRequest) {
            LOG.debug("Cancel slot request {}.", (Object)allocationId);
            if (pendingSlotRequest.isAssigned()) {
                this.cancelPendingSlotRequest(pendingSlotRequest);
            } else {
                this.resourceActions.cancelResourceAllocation(pendingSlotRequest.getResourceProfile(), new HashSet<SlotTag>(pendingSlotRequest.getSlotRequest().getTags()));
            }
            return true;
        }
        LOG.debug("No pending slot request with allocation id {} found. Ignoring unregistration request.", (Object)allocationId);
        return false;
    }

    public void registerTaskManager(TaskExecutorConnection taskExecutorConnection, SlotReport initialSlotReport) {
        this.checkInit();
        LOG.info("Registering TaskManager {} under {} at the SlotManager.", (Object)taskExecutorConnection.getResourceID(), (Object)taskExecutorConnection.getInstanceID());
        if (this.taskManagerRegistrations.containsKey((Object)taskExecutorConnection.getInstanceID())) {
            this.reportSlotStatus(taskExecutorConnection.getInstanceID(), initialSlotReport);
        } else {
            ArrayList<SlotID> reportedSlots = new ArrayList<SlotID>();
            for (SlotStatus slotStatus : initialSlotReport) {
                reportedSlots.add(slotStatus.getSlotID());
            }
            TaskManagerRegistration taskManagerRegistration = new TaskManagerRegistration(taskExecutorConnection, reportedSlots);
            this.taskManagerRegistrations.put(taskExecutorConnection.getInstanceID(), taskManagerRegistration);
            for (SlotStatus slotStatus : initialSlotReport) {
                this.registerSlot(slotStatus.getSlotID(), slotStatus.getAllocationID(), slotStatus.getJobID(), slotStatus.getAllocationResourceProfile(), slotStatus.getResourceProfile(), taskExecutorConnection, slotStatus.getVersion(), slotStatus.getTags());
            }
        }
    }

    public void setJobConstraints(JobID jobId, List<PlacementConstraint> constraints) {
        this.placementConstraintManager.setJobConstraints(jobId, constraints);
    }

    public boolean unregisterTaskManager(InstanceID instanceId) {
        this.checkInit();
        LOG.info("Unregister TaskManager {} from the SlotManager.", (Object)instanceId);
        TaskManagerRegistration taskManagerRegistration = this.taskManagerRegistrations.remove((Object)instanceId);
        if (null != taskManagerRegistration) {
            this.internalUnregisterTaskManager(taskManagerRegistration);
            return true;
        }
        LOG.debug("There is no task manager registered with instance ID {}. Ignoring this message.", (Object)instanceId);
        return false;
    }

    public boolean reportSlotStatus(InstanceID instanceId, SlotReport slotReport) {
        this.checkInit();
        LOG.debug("Received slot report from instance {}.", (Object)instanceId);
        TaskManagerRegistration taskManagerRegistration = this.taskManagerRegistrations.get((Object)instanceId);
        if (null != taskManagerRegistration) {
            for (SlotStatus slotStatus : slotReport) {
                TaskManagerSlot taskManagerSlot = this.slots.get(slotStatus.getSlotID());
                if (slotStatus.getVersion() > taskManagerSlot.getVersion()) {
                    LOG.warn("The version of slot {}'s report {} should not exceed that in ResourceManager {}", new Object[]{slotStatus.getSlotID(), slotStatus.getVersion(), taskManagerSlot.getVersion()});
                    continue;
                }
                if (slotStatus.getVersion() < taskManagerSlot.getVersion()) {
                    if (taskManagerSlot.getState() == TaskManagerSlot.State.SYNCING) {
                        this.reAllocateSlot(taskManagerSlot, taskManagerSlot.getAssignedSlotRequest());
                        continue;
                    }
                    LOG.debug("Received outdated slot report from task managerwith instance id {}. Current state leads. Ignoring this report.", (Object)instanceId);
                    continue;
                }
                this.updateSlot(slotStatus.getSlotID(), slotStatus.getAllocationID(), slotStatus.getJobID());
            }
            return true;
        }
        LOG.debug("Received slot report for unknown task manager with instance id {}. Ignoring this report.", (Object)instanceId);
        return false;
    }

    public void freeSlot(SlotID slotId, AllocationID allocationId) {
        this.checkInit();
        TaskManagerSlot slot = this.slots.get(slotId);
        if (null != slot) {
            if (slot.getState() == TaskManagerSlot.State.ALLOCATED) {
                if (Objects.equals((Object)allocationId, (Object)slot.getAllocationId())) {
                    TaskManagerRegistration taskManagerRegistration = this.taskManagerRegistrations.get((Object)slot.getInstanceId());
                    if (taskManagerRegistration == null) {
                        throw new IllegalStateException("Trying to free a slot from a TaskManager " + (Object)((Object)slot.getInstanceId()) + " which has not been registered.");
                    }
                    this.updateSlotState(slot, taskManagerRegistration, null, null);
                    this.allocationIdTags.remove((Object)allocationId);
                } else {
                    LOG.debug("Received request to free slot {} with expected allocation id {}, but actual allocation id {} differs. Ignoring the request.", new Object[]{slotId, allocationId, slot.getAllocationId()});
                }
            } else {
                LOG.debug("Slot {} has not been allocated.", (Object)allocationId);
            }
        } else {
            LOG.debug("Trying to free a slot {} which has not been registered. Ignoring this message.", (Object)slotId);
        }
    }

    public void enableIdleTaskManagersFastTimeout() {
        if (this.tmFastTimeout) {
            return;
        }
        this.tmFastTimeout = true;
        this.scheduleTaskManagerFastTimeoutCheck();
    }

    public void disableIdleTaskManagersFastTimeout() {
        this.tmFastTimeout = false;
    }

    private void scheduleTaskManagerFastTimeoutCheck() {
        this.scheduledExecutor.schedule(() -> this.mainThreadExecutor.execute(() -> {
            if (this.tmFastTimeout) {
                this.checkTaskManagerTimeouts(true);
                this.scheduleTaskManagerFastTimeoutCheck();
            }
        }), this.taskManagerFastTimeout.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    protected PendingSlotRequest findMatchingRequest(TaskManagerSlot taskManagerSlot) {
        for (PendingSlotRequest pendingSlotRequest : this.pendingSlotRequests.values()) {
            if (pendingSlotRequest.isAssigned() || !taskManagerSlot.getResourceProfile().isMatching(pendingSlotRequest.getResourceProfile()) || !this.placementConstraintManager.check(pendingSlotRequest.getJobId(), this.allocationIdTags.get((Object)pendingSlotRequest.getAllocationId()), this.getTaskExecutorSlotTags(taskManagerSlot.getSlotId()))) continue;
            return pendingSlotRequest;
        }
        return null;
    }

    protected TaskManagerSlot findMatchingSlot(SlotRequest slotRequest) {
        Iterator<Map.Entry<SlotID, TaskManagerSlot>> iterator = this.freeSlots.entrySet().iterator();
        while (iterator.hasNext()) {
            TaskManagerSlot taskManagerSlot = iterator.next().getValue();
            Preconditions.checkState((taskManagerSlot.getState() == TaskManagerSlot.State.FREE ? 1 : 0) != 0, (String)"TaskManagerSlot %s is not in state FREE but %s.", (Object[])new Object[]{taskManagerSlot.getSlotId(), taskManagerSlot.getState()});
            if (!taskManagerSlot.getResourceProfile().isMatching(slotRequest.getResourceProfile()) || !this.placementConstraintManager.check(slotRequest.getJobId(), this.allocationIdTags.get((Object)slotRequest.getAllocationId()), this.getTaskExecutorSlotTags(taskManagerSlot.getSlotId()))) continue;
            iterator.remove();
            return taskManagerSlot;
        }
        return null;
    }

    private void registerSlot(SlotID slotId, AllocationID allocationId, JobID jobId, ResourceProfile allocationResourceProfile, ResourceProfile resourceProfile, TaskExecutorConnection taskManagerConnection, long initialVersion, List<SlotTag> tags) {
        if (this.slots.containsKey(slotId)) {
            this.removeSlot(slotId);
        }
        TaskManagerSlot slot = new TaskManagerSlot(slotId, resourceProfile, taskManagerConnection, initialVersion);
        this.slots.put(slotId, slot);
        this.updateSlot(slotId, allocationId, jobId);
        if (allocationId != null) {
            if (tags == null) {
                LOG.warn("Slot with SlotID {} is registered with AllocationID {}, slot tags should not be null.", (Object)slotId, (Object)allocationId);
            } else {
                this.allocationIdTags.put(allocationId, tags);
            }
        }
        if (this.slotListener != null && allocationId != null) {
            Preconditions.checkNotNull((Object)allocationResourceProfile, (String)"The allocation resource profile should be reported together");
            this.slotListener.notifySlotRegistered(slotId, allocationResourceProfile);
        }
    }

    private boolean updateSlot(SlotID slotId, AllocationID allocationId, JobID jobId) {
        TaskManagerSlot slot = this.slots.get(slotId);
        if (slot != null) {
            TaskManagerRegistration taskManagerRegistration = this.taskManagerRegistrations.get((Object)slot.getInstanceId());
            if (taskManagerRegistration != null) {
                this.updateSlotState(slot, taskManagerRegistration, allocationId, jobId);
                return true;
            }
            throw new IllegalStateException("Trying to update a slot from a TaskManager " + (Object)((Object)slot.getInstanceId()) + " which has not been registered.");
        }
        LOG.debug("Trying to update unknown slot with slot id {}.", (Object)slotId);
        return false;
    }

    private void updateSlotState(TaskManagerSlot slot, TaskManagerRegistration taskManagerRegistration, @Nullable AllocationID allocationId, @Nullable JobID jobId) {
        if (null != allocationId) {
            switch (slot.getState()) {
                case SYNCING: {
                    slot.syncState(TaskManagerSlot.State.PENDING);
                }
                case PENDING: {
                    PendingSlotRequest pendingSlotRequest = slot.getAssignedSlotRequest();
                    if (Objects.equals((Object)pendingSlotRequest.getAllocationId(), (Object)allocationId)) {
                        this.cancelPendingSlotRequest(pendingSlotRequest);
                        this.pendingSlotRequests.remove((Object)pendingSlotRequest.getAllocationId());
                        slot.completeAllocation(allocationId, jobId);
                    } else {
                        slot.clearPendingSlotRequest();
                        slot.updateAllocation(allocationId, jobId);
                        this.rejectPendingSlotRequest(pendingSlotRequest, new Exception("Task manager reported slot " + slot.getSlotId() + " being already allocated."));
                    }
                    taskManagerRegistration.occupySlot();
                    break;
                }
                case ALLOCATED: {
                    if (Objects.equals((Object)allocationId, (Object)slot.getAllocationId())) break;
                    slot.freeSlot();
                    slot.updateAllocation(allocationId, jobId);
                    break;
                }
                case FREE: {
                    this.freeSlots.remove(slot.getSlotId());
                    slot.updateAllocation(allocationId, jobId);
                    taskManagerRegistration.occupySlot();
                }
            }
            this.fulfilledSlotRequests.put(allocationId, slot.getSlotId());
        } else {
            switch (slot.getState()) {
                case SYNCING: {
                    slot.clearPendingSlotRequest();
                }
                case FREE: {
                    this.freeSlots.remove(slot.getSlotId());
                    this.handleFreeSlot(slot);
                    break;
                }
                case PENDING: {
                    break;
                }
                case ALLOCATED: {
                    AllocationID oldAllocation = slot.getAllocationId();
                    slot.freeSlot();
                    this.fulfilledSlotRequests.remove((Object)oldAllocation);
                    taskManagerRegistration.freeSlot();
                    this.handleFreeSlot(slot);
                }
            }
        }
    }

    private void internalRequestSlot(PendingSlotRequest pendingSlotRequest) throws ResourceManagerException {
        TaskManagerSlot taskManagerSlot = this.findMatchingSlot(pendingSlotRequest.getSlotRequest());
        if (taskManagerSlot != null) {
            LOG.info("Assigning slot {} to {}", (Object)taskManagerSlot.getSlotId(), (Object)pendingSlotRequest.getAllocationId());
            this.allocateSlot(taskManagerSlot, pendingSlotRequest);
        } else {
            this.resourceActions.allocateResource(pendingSlotRequest.getResourceProfile(), new HashSet<SlotTag>(pendingSlotRequest.getSlotRequest().getTags()));
        }
    }

    private void allocateSlot(TaskManagerSlot taskManagerSlot, PendingSlotRequest pendingSlotRequest) {
        Preconditions.checkState((taskManagerSlot.getState() == TaskManagerSlot.State.FREE ? 1 : 0) != 0);
        taskManagerSlot.increaseVersion();
        taskManagerSlot.assignPendingSlotRequest(pendingSlotRequest);
        CompletableFuture<Acknowledge> completableFuture = this.sendSlotAllocationRequest(taskManagerSlot, pendingSlotRequest);
        AllocationID allocationId = pendingSlotRequest.getAllocationId();
        SlotID slotId = taskManagerSlot.getSlotId();
        completableFuture.whenCompleteAsync((acknowledge, throwable) -> {
            try {
                if (acknowledge != null) {
                    this.updateSlot(slotId, allocationId, pendingSlotRequest.getJobId());
                } else {
                    if (throwable instanceof SlotOccupiedException) {
                        SlotOccupiedException exception = (SlotOccupiedException)throwable;
                        this.updateSlot(slotId, exception.getAllocationId(), exception.getJobId());
                    } else if (throwable instanceof AskTimeoutException || throwable instanceof CancellationException) {
                        this.syncSlotForSlotRequest(slotId, allocationId);
                    } else {
                        this.removeSlotRequestFromSlot(slotId, allocationId);
                    }
                    if (!(throwable instanceof AskTimeoutException) && !(throwable instanceof CancellationException)) {
                        this.handleFailedSlotRequest(slotId, allocationId, (Throwable)throwable);
                    } else {
                        LOG.debug("Slot allocation request {} has been cancelled or timeout.", (Object)allocationId, throwable);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error while completing the slot allocation.", (Throwable)e);
            }
        }, this.mainThreadExecutor);
    }

    private void reAllocateSlot(TaskManagerSlot taskManagerSlot, PendingSlotRequest pendingSlotRequest) {
        Preconditions.checkState((taskManagerSlot.getState() == TaskManagerSlot.State.SYNCING ? 1 : 0) != 0, (Object)String.format("Slot %s is in state %s", new Object[]{taskManagerSlot.getSlotId(), taskManagerSlot.getState()}));
        LOG.info("Assigning slot {} to allocation {}", (Object)taskManagerSlot.getSlotId(), (Object)pendingSlotRequest.getAllocationId());
        CompletableFuture<Acknowledge> completableFuture = this.sendSlotAllocationRequest(taskManagerSlot, pendingSlotRequest);
        AllocationID allocationId = pendingSlotRequest.getAllocationId();
        SlotID slotId = taskManagerSlot.getSlotId();
        completableFuture.whenCompleteAsync((acknowledge, throwable) -> {
            try {
                if (acknowledge != null) {
                    this.updateSlot(slotId, allocationId, pendingSlotRequest.getJobId());
                } else {
                    LOG.debug("Slot allocation request {} has failed.", (Object)allocationId, throwable);
                }
            }
            catch (Exception e) {
                LOG.error("Error while completing the slot allocation.", (Throwable)e);
            }
        }, this.mainThreadExecutor);
    }

    private CompletableFuture<Acknowledge> sendSlotAllocationRequest(TaskManagerSlot taskManagerSlot, PendingSlotRequest pendingSlotRequest) {
        TaskExecutorConnection taskExecutorConnection = taskManagerSlot.getTaskManagerConnection();
        TaskExecutorGateway gateway = taskExecutorConnection.getTaskExecutorGateway();
        CompletableFuture<Acknowledge> completableFuture = new CompletableFuture<Acknowledge>();
        AllocationID allocationId = pendingSlotRequest.getAllocationId();
        SlotID slotId = taskManagerSlot.getSlotId();
        InstanceID instanceID = taskManagerSlot.getInstanceId();
        pendingSlotRequest.setRequestFuture(completableFuture);
        TaskManagerRegistration taskManagerRegistration = this.taskManagerRegistrations.get((Object)instanceID);
        if (taskManagerRegistration == null) {
            throw new IllegalStateException("Could not find a registered task manager for instance id " + (Object)((Object)instanceID) + '.');
        }
        taskManagerRegistration.markUsed();
        CompletableFuture<Acknowledge> requestFuture = gateway.requestSlot(slotId, pendingSlotRequest.getJobId(), allocationId, pendingSlotRequest.getResourceProfile(), pendingSlotRequest.getTargetAddress(), pendingSlotRequest.getSlotRequest().getTags(), this.resourceManagerId, taskManagerSlot.getVersion(), this.taskManagerRequestTimeout);
        requestFuture.whenComplete((acknowledge, throwable) -> {
            if (acknowledge != null) {
                completableFuture.complete((Acknowledge)acknowledge);
            } else {
                completableFuture.completeExceptionally((Throwable)throwable);
            }
        });
        return completableFuture;
    }

    private void handleFreeSlot(TaskManagerSlot freeSlot) {
        PendingSlotRequest pendingSlotRequest;
        Preconditions.checkState((freeSlot.getState() == TaskManagerSlot.State.FREE ? 1 : 0) != 0);
        if (this.slotListener != null) {
            this.slotListener.notifySlotFree(freeSlot.getSlotId());
        }
        if (null != (pendingSlotRequest = this.findMatchingRequest(freeSlot))) {
            LOG.info("Assigning free slot {} to {}", (Object)freeSlot.getSlotId(), (Object)pendingSlotRequest.getAllocationId());
            this.allocateSlot(freeSlot, pendingSlotRequest);
        } else {
            this.freeSlots.put(freeSlot.getSlotId(), freeSlot);
        }
    }

    private void removeSlots(Iterable<SlotID> slotsToRemove) {
        for (SlotID slotId : slotsToRemove) {
            this.removeSlot(slotId);
        }
    }

    private void removeSlot(SlotID slotId) {
        TaskManagerSlot slot = this.slots.remove(slotId);
        if (null != slot) {
            AllocationID oldAllocationId;
            this.freeSlots.remove(slotId);
            if (slot.getState() == TaskManagerSlot.State.PENDING) {
                this.rejectPendingSlotRequest(slot.getAssignedSlotRequest(), new Exception("The assigned slot " + slot.getSlotId() + " was removed."));
            }
            if ((oldAllocationId = slot.getAllocationId()) != null) {
                this.fulfilledSlotRequests.remove((Object)oldAllocationId);
                this.resourceActions.notifyAllocationFailure(slot.getJobId(), oldAllocationId, (Exception)((Object)new FlinkException("The assigned slot " + slot.getSlotId() + " was removed.")));
            }
            if (this.slotListener != null) {
                this.slotListener.notifySlotRemoved(slotId);
            }
        } else {
            LOG.debug("There was no slot registered with slot id {}.", (Object)slotId);
        }
    }

    private void removeSlotRequestFromSlot(SlotID slotId, AllocationID allocationId) {
        TaskManagerSlot taskManagerSlot = this.slots.get(slotId);
        if (null != taskManagerSlot) {
            if (taskManagerSlot.getState() == TaskManagerSlot.State.PENDING && Objects.equals((Object)allocationId, (Object)taskManagerSlot.getAssignedSlotRequest().getAllocationId())) {
                TaskManagerRegistration taskManagerRegistration = this.taskManagerRegistrations.get((Object)taskManagerSlot.getInstanceId());
                if (taskManagerRegistration == null) {
                    throw new IllegalStateException("Trying to remove slot request from slot for which there is no TaskManager " + (Object)((Object)taskManagerSlot.getInstanceId()) + " is registered.");
                }
                taskManagerSlot.clearPendingSlotRequest();
                this.updateSlotState(taskManagerSlot, taskManagerRegistration, null, null);
            } else {
                LOG.debug("Ignore slot request removal for slot {}.", (Object)slotId);
            }
        } else {
            LOG.debug("There was no slot with {} registered. Probably this slot has been already freed.", (Object)slotId);
        }
    }

    private void syncSlotForSlotRequest(SlotID slotId, AllocationID allocationId) {
        TaskManagerSlot taskManagerSlot = this.slots.get(slotId);
        if (null != taskManagerSlot) {
            if (taskManagerSlot.getState() == TaskManagerSlot.State.PENDING && Objects.equals((Object)allocationId, (Object)taskManagerSlot.getAssignedSlotRequest().getAllocationId())) {
                TaskManagerRegistration taskManagerRegistration = this.taskManagerRegistrations.get((Object)taskManagerSlot.getInstanceId());
                if (taskManagerRegistration == null) {
                    throw new IllegalStateException("Trying to sync slot for request from slot for which there is no TaskManager " + (Object)((Object)taskManagerSlot.getInstanceId()) + " is registered.");
                }
                taskManagerSlot.syncPendingSlotRequest();
            } else {
                LOG.debug("Ignore slot {} sync for request.", (Object)slotId);
            }
        } else {
            LOG.debug("There was no slot with {} registered. Probably this slot has been already freed.", (Object)slotId);
        }
    }

    private void handleFailedSlotRequest(SlotID slotId, AllocationID allocationId, Throwable cause) {
        PendingSlotRequest pendingSlotRequest = this.pendingSlotRequests.get((Object)allocationId);
        LOG.debug("Slot request with allocation id {} failed for slot {}.", new Object[]{allocationId, slotId, cause});
        if (null != pendingSlotRequest) {
            pendingSlotRequest.setRequestFuture(null);
            try {
                this.internalRequestSlot(pendingSlotRequest);
            }
            catch (ResourceManagerException e) {
                this.pendingSlotRequests.remove((Object)allocationId);
                this.resourceActions.notifyAllocationFailure(pendingSlotRequest.getJobId(), allocationId, e);
            }
        } else {
            LOG.debug("There was not pending slot request with allocation id {}. Probably the request has been fulfilled or cancelled.", (Object)allocationId);
        }
    }

    private void rejectPendingSlotRequest(PendingSlotRequest pendingSlotRequest, Exception cause) {
        CompletableFuture<Acknowledge> request = pendingSlotRequest.getRequestFuture();
        if (null != request) {
            request.completeExceptionally(new SlotAllocationException(cause));
        } else {
            LOG.debug("Cannot reject pending slot request {}, since no request has been sent.", (Object)pendingSlotRequest.getAllocationId());
        }
    }

    private void cancelPendingSlotRequest(PendingSlotRequest pendingSlotRequest) {
        CompletableFuture<Acknowledge> request = pendingSlotRequest.getRequestFuture();
        if (null != request) {
            request.cancel(false);
        }
    }

    private void checkTaskManagerTimeouts(boolean fast) {
        Time timeout;
        Time time = timeout = fast ? this.taskManagerFastTimeout : this.taskManagerTimeout;
        if (!this.taskManagerRegistrations.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            ArrayList<InstanceID> timedOutTaskManagerIds = new ArrayList<InstanceID>(this.taskManagerRegistrations.size());
            for (TaskManagerRegistration taskManagerRegistration : this.taskManagerRegistrations.values()) {
                if (currentTime - taskManagerRegistration.getIdleSince() < timeout.toMilliseconds()) continue;
                timedOutTaskManagerIds.add(taskManagerRegistration.getInstanceId());
            }
            for (InstanceID timedOutTaskManagerId : timedOutTaskManagerIds) {
                LOG.debug("Release TaskExecutor {} because it exceeded the idle timeout. fast: {}", (Object)timedOutTaskManagerId, (Object)fast);
                this.resourceActions.releaseResource(timedOutTaskManagerId, (Exception)((Object)new FlinkException("TaskExecutor exceeded the idle timeout.")));
            }
        }
    }

    private void checkSlotRequestTimeouts() {
        if (!this.pendingSlotRequests.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            Iterator<Map.Entry<AllocationID, PendingSlotRequest>> slotRequestIterator = this.pendingSlotRequests.entrySet().iterator();
            while (slotRequestIterator.hasNext()) {
                PendingSlotRequest slotRequest = slotRequestIterator.next().getValue();
                if (currentTime - slotRequest.getCreationTimestamp() < this.slotRequestTimeout.toMilliseconds()) continue;
                slotRequestIterator.remove();
                if (slotRequest.isAssigned()) {
                    this.cancelPendingSlotRequest(slotRequest);
                }
                this.resourceActions.notifyAllocationFailure(slotRequest.getJobId(), slotRequest.getAllocationId(), new TimeoutException("The allocation could not be fulfilled in time."));
            }
        }
    }

    private void internalUnregisterTaskManager(TaskManagerRegistration taskManagerRegistration) {
        Preconditions.checkNotNull((Object)taskManagerRegistration);
        this.removeSlots(taskManagerRegistration.getSlots());
    }

    private boolean checkDuplicateRequest(AllocationID allocationId) {
        return this.pendingSlotRequests.containsKey((Object)allocationId) || this.fulfilledSlotRequests.containsKey((Object)allocationId);
    }

    private void checkInit() {
        Preconditions.checkState((boolean)this.started, (Object)"The slot manager has not been started.");
    }

    protected List<List<SlotTag>> getTaskExecutorSlotTags(SlotID slotID) {
        ArrayList<List<SlotTag>> taskExecutorSlotTags = new ArrayList<List<SlotTag>>();
        InstanceID instanceID = this.slots.get(slotID).getInstanceId();
        this.taskManagerRegistrations.get((Object)instanceID).getSlots().forEach(taskExecutorSlotId -> {
            TaskManagerSlot slot = this.slots.get(taskExecutorSlotId);
            if (slot == null) {
                return;
            }
            AllocationID allocationId = slot.getAllocationId();
            if (allocationId == null && slot.getAssignedSlotRequest() != null) {
                allocationId = slot.getAssignedSlotRequest().getAllocationId();
            }
            if (allocationId == null || !this.allocationIdTags.containsKey((Object)allocationId)) {
                return;
            }
            taskExecutorSlotTags.add(this.allocationIdTags.get((Object)allocationId));
        });
        return taskExecutorSlotTags;
    }

    @VisibleForTesting
    TaskManagerSlot getSlot(SlotID slotId) {
        return this.slots.get(slotId);
    }

    @VisibleForTesting
    PendingSlotRequest getSlotRequest(AllocationID allocationId) {
        return this.pendingSlotRequests.get((Object)allocationId);
    }

    @VisibleForTesting
    boolean isTaskManagerIdle(InstanceID instanceId) {
        TaskManagerRegistration taskManagerRegistration = this.taskManagerRegistrations.get((Object)instanceId);
        if (null != taskManagerRegistration) {
            return taskManagerRegistration.isIdle();
        }
        return false;
    }

    @VisibleForTesting
    public void unregisterTaskManagersAndReleaseResources() {
        Iterator<Map.Entry<InstanceID, TaskManagerRegistration>> taskManagerRegistrationIterator = this.taskManagerRegistrations.entrySet().iterator();
        while (taskManagerRegistrationIterator.hasNext()) {
            TaskManagerRegistration taskManagerRegistration = taskManagerRegistrationIterator.next().getValue();
            taskManagerRegistrationIterator.remove();
            this.internalUnregisterTaskManager(taskManagerRegistration);
            this.resourceActions.releaseResource(taskManagerRegistration.getInstanceId(), (Exception)((Object)new FlinkException("Triggering of SlotManager#unregisterTaskManagersAndReleaseResources.")));
        }
    }

    @VisibleForTesting
    List<SlotTag> getTagsForSlotRequest(SlotRequest slotRequest) {
        return this.allocationIdTags.get((Object)slotRequest.getAllocationId());
    }

    @VisibleForTesting
    List<List<SlotTag>> getTagsForTaskExecutor(ResourceID resourceId) {
        SlotID slotId = null;
        for (SlotID sid : this.slots.keySet()) {
            if (!sid.getResourceID().equals(resourceId)) continue;
            slotId = sid;
            break;
        }
        if (slotId == null) {
            return Collections.emptyList();
        }
        return this.getTaskExecutorSlotTags(slotId);
    }

    protected static interface SlotListener {
        public void notifySlotRegistered(SlotID var1, ResourceProfile var2);

        public void notifySlotFree(SlotID var1);

        public void notifySlotRemoved(SlotID var1);
    }
}

