/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.util.EvictingBoundedList;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public abstract class AbstractExecutionGraphsHandler<R extends ResponseBody, M extends JobMessageParameters>
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, R, M> {
    private final ExecutionGraphCache executionGraphCache;
    private final Executor executor;

    protected AbstractExecutionGraphsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, R, M> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.executionGraphCache = (ExecutionGraphCache)Preconditions.checkNotNull((Object)executionGraphCache);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    protected CompletableFuture<R> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, M> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        CompletableFuture<AccessExecutionGraph> executionGraphFuture = this.executionGraphCache.getExecutionGraph(jobId, gateway);
        CompletableFuture<EvictingBoundedList<ArchivedExecutionGraph>> historicalGraphsFuture = gateway.requestJobHistories(jobId, this.timeout);
        return ((CompletableFuture)((CompletableFuture)executionGraphFuture.thenApplyAsync(graph -> {
            Tuple2 graphTuple2 = new Tuple2();
            graphTuple2.setField(graph, 0);
            try {
                EvictingBoundedList historicalGraphs = (EvictingBoundedList)historicalGraphsFuture.get(this.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
                graphTuple2.setField((Object)historicalGraphs, 1);
            }
            catch (Exception ignore) {
                graphTuple2.setField(null, 1);
            }
            return graphTuple2;
        }, this.executor)).thenApplyAsync(graphTuple2 -> {
            try {
                return this.handleRequest(request, (AccessExecutionGraph)graphTuple2.f0, (EvictingBoundedList)graphTuple2.f1);
            }
            catch (RestHandlerException rhe) {
                throw new CompletionException((Throwable)((Object)rhe));
            }
        }, this.executor)).exceptionally(throwable -> {
            if ((throwable = ExceptionUtils.stripCompletionException((Throwable)throwable)) instanceof FlinkJobNotFoundException) {
                throw new CompletionException((Throwable)((Object)new NotFoundException(String.format("Job %s not found", jobId), (Throwable)throwable)));
            }
            throw new CompletionException((Throwable)throwable);
        });
    }

    protected abstract R handleRequest(HandlerRequest<EmptyRequestBody, M> var1, AccessExecutionGraph var2, EvictingBoundedList<ArchivedExecutionGraph> var3) throws RestHandlerException;

    protected static List<AccessExecutionJobVertex> getVertex(EvictingBoundedList<ArchivedExecutionGraph> historicalGraphs, AccessExecutionJobVertex jobVertex) {
        ArrayList<AccessExecutionJobVertex> vertexList = new ArrayList<AccessExecutionJobVertex>();
        vertexList.add(jobVertex);
        if (historicalGraphs != null) {
            for (ArchivedExecutionGraph graph : historicalGraphs) {
                ArchivedExecutionJobVertex v;
                if (graph == null || (v = graph.getJobVertex(jobVertex.getJobVertexId())) == null) continue;
                vertexList.add(v);
            }
        }
        return vertexList;
    }
}

