/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.JobSubtaskCurrentAttemptsInfo;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobAllSubtaskCurrentAttemptsHandler
extends AbstractExecutionGraphHandler<JobSubtaskCurrentAttemptsInfo, JobMessageParameters> {
    public JobAllSubtaskCurrentAttemptsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobSubtaskCurrentAttemptsInfo, JobMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected JobSubtaskCurrentAttemptsInfo handleRequest(HandlerRequest<EmptyRequestBody, JobMessageParameters> request, AccessExecutionGraph executionGraph) throws RestHandlerException {
        ArrayList<SubtaskExecutionAttemptInfo> subtaskExecutionAttemptsInfo = new ArrayList<SubtaskExecutionAttemptInfo>();
        for (AccessExecutionJobVertex accessExecutionJobVertex : executionGraph.getVerticesTopologically()) {
            String vertexId = accessExecutionJobVertex.getJobVertexId().toString();
            for (AccessExecutionVertex executionVertex : accessExecutionJobVertex.getTaskVertices()) {
                AccessExecution execution = executionVertex.getCurrentExecutionAttempt();
                SubtaskExecutionAttemptInfo subtaskExecutionAttemptInfo = SubtaskExecutionAttemptInfo.create(execution, vertexId);
                subtaskExecutionAttemptsInfo.add(subtaskExecutionAttemptInfo);
            }
        }
        return new JobSubtaskCurrentAttemptsInfo(executionGraph.getState(), subtaskExecutionAttemptsInfo);
    }
}

