/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobGraphOverviewInfo;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ResourceSpecInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.AbstractID;

public class JobGraphOverviewHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, JobGraphOverviewInfo, JobMessageParameters> {
    public JobGraphOverviewHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobGraphOverviewInfo, JobMessageParameters> messageHeaders) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders);
    }

    @Override
    protected CompletableFuture<JobGraphOverviewInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, JobMessageParameters> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        JobID jobID = (JobID)request.getPathParameter(JobIDPathParameter.class);
        return gateway.requestJobGraph(jobID, this.timeout).thenApply(jobGraph -> {
            Configuration config = jobGraph.getJobConfiguration();
            HashMap<String, JobGraphOverviewInfo.VertexConfigInfo> vertexConfigs = new HashMap<String, JobGraphOverviewInfo.VertexConfigInfo>();
            HashMap<String, List<JobGraphOverviewInfo.EdgeConfigInfo>> inputNodes = new HashMap<String, List<JobGraphOverviewInfo.EdgeConfigInfo>>();
            for (JobVertex vertex : jobGraph.getVertices()) {
                JobVertexID vertexID = vertex.getID();
                List<Object> nodeIds = vertex.getOperatorDescriptors() != null ? vertex.getOperatorDescriptors().stream().map(op -> op.getNodeId()).collect(Collectors.toList()) : new ArrayList();
                List<Object> inputVertexId = vertex.getInputs() != null ? vertex.getInputs().stream().map(edge -> new JobGraphOverviewInfo.EdgeConfigInfo(edge.getSource().getProducer().getID().toString(), edge.getShipStrategyName())).collect(Collectors.toList()) : new ArrayList();
                ResourceSpec resourceSpec = vertex.getMinResources();
                HashMap<String, ResourceSpecInfo.ResourceInfo> extendedResource = new HashMap<String, ResourceSpecInfo.ResourceInfo>();
                if (resourceSpec.getExtendedResources().size() > 0) {
                    for (Map.Entry name2Resource : resourceSpec.getExtendedResources().entrySet()) {
                        extendedResource.put((String)name2Resource.getKey(), new ResourceSpecInfo.ResourceInfo((Resource)name2Resource.getValue()));
                    }
                }
                ResourceSpecInfo resourceSpecInfo = new ResourceSpecInfo(resourceSpec.getCpuCores(), resourceSpec.getHeapMemory(), resourceSpec.getDirectMemory(), resourceSpec.getNativeMemory(), resourceSpec.getStateSize(), extendedResource);
                AbstractID coLocationGroupId = vertex.getCoLocationGroup() != null ? vertex.getCoLocationGroup().getId() : null;
                JobGraphOverviewInfo.VertexConfigInfo vertexConfigInfo = new JobGraphOverviewInfo.VertexConfigInfo(vertexID, vertex.getName(), vertex.getParallelism(), vertex.getMaxParallelism(), resourceSpecInfo, nodeIds, coLocationGroupId);
                vertexConfigs.put(vertexID.toString(), vertexConfigInfo);
                inputNodes.put(vertexID.toString(), inputVertexId);
            }
            return new JobGraphOverviewInfo(config.toMap(), vertexConfigs, inputNodes);
        });
    }
}

