/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractComponentsMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.ComponentsMetricCollectionResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public abstract class AbstractJobComponentMetricsHandler<M extends MessageParameters>
extends AbstractComponentsMetricsHandler<M> {
    private final ExecutionGraphCache executionGraphCache;

    public AbstractJobComponentMetricsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> headers, MessageHeaders<EmptyRequestBody, ComponentsMetricCollectionResponseBody, M> messageHeaders, ExecutionGraphCache executionGraphCache, MetricFetcher metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, headers, messageHeaders, metricFetcher);
        this.executionGraphCache = executionGraphCache;
    }

    @Override
    protected Set<String> getAvailableComponents(Set<String> requestedComponenets, RestfulGateway gateway, HandlerRequest<EmptyRequestBody, M> request) throws NotFoundException {
        if (requestedComponenets.isEmpty()) {
            JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
            AccessExecutionGraph executionGraph = null;
            try {
                executionGraph = this.executionGraphCache.getExecutionGraph(jobId, gateway).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.getAvailableComponents(executionGraph, request);
        }
        return requestedComponenets;
    }

    protected abstract Set<String> getAvailableComponents(AccessExecutionGraph var1, HandlerRequest<EmptyRequestBody, M> var2) throws NotFoundException;
}

