/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractJobComponentMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.JobTaskManagersComponentMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.JobTaskManagersComponentMetricsMessageParameters;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobTaskManagersComponentMetricsHandler
extends AbstractJobComponentMetricsHandler<JobTaskManagersComponentMetricsMessageParameters> {
    public JobTaskManagersComponentMetricsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> headers, ExecutionGraphCache executionGraphCache, MetricFetcher metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, headers, JobTaskManagersComponentMetricsHeaders.getInstance(), executionGraphCache, metricFetcher);
    }

    @Override
    @Nullable
    protected Map<String, MetricStore.ComponentMetricStore> getComponentId2MetricStores(HandlerRequest<EmptyRequestBody, JobTaskManagersComponentMetricsMessageParameters> request, MetricStore metricStore, Set<String> requestedComponents) {
        HashMap<String, MetricStore.ComponentMetricStore> componentId2MetricStores = new HashMap<String, MetricStore.ComponentMetricStore>();
        if (requestedComponents.isEmpty()) {
            return componentId2MetricStores;
        }
        for (String componentId : requestedComponents) {
            MetricStore.TaskManagerMetricStore componentMetricStore = metricStore.getTaskManagerMetricStore(componentId);
            componentId2MetricStores.put(componentId, componentMetricStore);
        }
        return componentId2MetricStores;
    }

    @Override
    protected Set<String> getAvailableComponents(AccessExecutionGraph executionGraph, HandlerRequest<EmptyRequestBody, JobTaskManagersComponentMetricsMessageParameters> request) {
        HashSet<String> taskManagerIds = new HashSet<String>();
        for (AccessExecutionJobVertex accessExecutionJobVertex : executionGraph.getVerticesTopologically()) {
            for (AccessExecutionVertex task : accessExecutionJobVertex.getTaskVertices()) {
                TaskManagerLocation taskManagerLocation = task.getCurrentAssignedResourceLocation();
                if (taskManagerLocation == null) continue;
                ResourceID tmId = taskManagerLocation.getResourceID();
                taskManagerIds.add(tmId.getResourceIdString());
            }
        }
        return taskManagerIds;
    }
}

