/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractComponentsMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.TaskManagersComponentMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.TaskManagersComponentMetricsMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class TaskManagersComponentMetricsHandler
extends AbstractComponentsMetricsHandler<TaskManagersComponentMetricsMessageParameters> {
    public TaskManagersComponentMetricsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> headers, MetricFetcher metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, headers, TaskManagersComponentMetricsHeaders.getInstance(), metricFetcher);
    }

    @Override
    @Nullable
    protected Map<String, MetricStore.ComponentMetricStore> getComponentId2MetricStores(HandlerRequest<EmptyRequestBody, TaskManagersComponentMetricsMessageParameters> request, MetricStore metricStore, Set<String> requestedComponents) {
        HashMap<String, MetricStore.ComponentMetricStore> componentId2MetricStores = new HashMap<String, MetricStore.ComponentMetricStore>();
        if (requestedComponents.isEmpty()) {
            return componentId2MetricStores;
        }
        for (String componentId : requestedComponents) {
            MetricStore.TaskManagerMetricStore componentMetricStore = metricStore.getTaskManagerMetricStore(componentId);
            componentId2MetricStores.put(componentId, componentMetricStore);
        }
        return componentId2MetricStores;
    }
}

