/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.exceptions.UnknownTaskExecutorException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.handler.taskmanager.AbstractTaskManagerHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerDetailsInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerIdPathParameter;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMetricsInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class TaskManagerDetailsHandler
extends AbstractTaskManagerHandler<RestfulGateway, EmptyRequestBody, TaskManagerDetailsInfo, TaskManagerMessageParameters> {
    private final MetricFetcher metricFetcher;
    private final MetricStore metricStore;

    public TaskManagerDetailsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, TaskManagerDetailsInfo, TaskManagerMessageParameters> messageHeaders, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, MetricFetcher metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, resourceManagerGatewayRetriever);
        this.metricFetcher = (MetricFetcher)Preconditions.checkNotNull((Object)metricFetcher);
        this.metricStore = metricFetcher.getMetricStore();
    }

    @Override
    protected CompletableFuture<TaskManagerDetailsInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, TaskManagerMessageParameters> request, @Nonnull ResourceManagerGateway gateway) throws RestHandlerException {
        ResourceID taskManagerResourceId = (ResourceID)request.getPathParameter(TaskManagerIdPathParameter.class);
        CompletableFuture<TaskManagerInfo> taskManagerInfoFuture = gateway.requestTaskManagerInfo(taskManagerResourceId, this.timeout);
        this.metricFetcher.update();
        return ((CompletableFuture)taskManagerInfoFuture.thenApply(taskManagerInfo -> {
            TaskManagerMetricsInfo taskManagerMetricsInfo;
            MetricStore.TaskManagerMetricStore tmMetrics = this.metricStore.getTaskManagerMetricStore(taskManagerResourceId.getResourceIdString());
            if (tmMetrics != null) {
                this.log.debug("Create metrics info for TaskManager {}.", (Object)taskManagerResourceId);
                taskManagerMetricsInfo = new TaskManagerMetricsInfo(tmMetrics);
            } else {
                this.log.debug("No metrics for TaskManager {}.", (Object)taskManagerResourceId);
                taskManagerMetricsInfo = TaskManagerMetricsInfo.empty();
            }
            return new TaskManagerDetailsInfo((TaskManagerInfo)taskManagerInfo, taskManagerMetricsInfo);
        })).exceptionally(throwable -> {
            Throwable strippedThrowable = ExceptionUtils.stripExecutionException((Throwable)throwable);
            if (strippedThrowable instanceof UnknownTaskExecutorException) {
                throw new CompletionException((Throwable)((Object)new RestHandlerException("Could not find TaskExecutor " + taskManagerResourceId + '.', HttpResponseStatus.NOT_FOUND, strippedThrowable)));
            }
            throw new CompletionException(strippedThrowable);
        });
    }
}

