/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.exceptions.UnknownTaskExecutorException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.taskmanager.AbstractTaskManagerHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.FileRangeMessageParameters;
import org.apache.flink.runtime.rest.messages.taskmanager.FileReadCountQueryParameter;
import org.apache.flink.runtime.rest.messages.taskmanager.FileReadStartQueryParameter;
import org.apache.flink.runtime.rest.messages.taskmanager.LogDetail;
import org.apache.flink.runtime.rest.messages.taskmanager.LogFileNamePathParameter;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerIdPathParameter;
import org.apache.flink.runtime.util.FileOffsetRange;
import org.apache.flink.runtime.util.FileReadDetail;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.guava18.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.guava18.com.google.common.cache.CacheLoader;
import org.apache.flink.shaded.guava18.com.google.common.cache.LoadingCache;
import org.apache.flink.shaded.guava18.com.google.common.cache.RemovalNotification;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public abstract class TaskManagerFileRangeHandler
extends AbstractTaskManagerHandler<RestfulGateway, EmptyRequestBody, LogDetail, FileRangeMessageParameters> {
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;
    private final TransientBlobService transientBlobService;
    private final LoadingCache<FileReadDetail, CompletableFuture<Tuple2<TransientBlobKey, Long>>> fileBlobKey2lengths;

    protected TaskManagerFileRangeHandler(@Nonnull CompletableFuture<String> localAddressFuture, @Nonnull GatewayRetriever<? extends RestfulGateway> leaderRetriever, @Nonnull Time timeout, @Nonnull Map<String, String> responseHeaders, @Nonnull MessageHeaders<EmptyRequestBody, LogDetail, FileRangeMessageParameters> messageHeaders, @Nonnull GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, @Nonnull TransientBlobService transientBlobService, @Nonnull Time cacheEntryDuration) {
        super(localAddressFuture, leaderRetriever, timeout, responseHeaders, messageHeaders, resourceManagerGatewayRetriever);
        this.resourceManagerGatewayRetriever = (GatewayRetriever)Preconditions.checkNotNull(resourceManagerGatewayRetriever);
        this.transientBlobService = (TransientBlobService)Preconditions.checkNotNull((Object)transientBlobService);
        this.fileBlobKey2lengths = CacheBuilder.newBuilder().expireAfterWrite(cacheEntryDuration.toMilliseconds(), TimeUnit.MILLISECONDS).removalListener(this::removeBlob).build((CacheLoader)new CacheLoader<FileReadDetail, CompletableFuture<Tuple2<TransientBlobKey, Long>>>(){

            public CompletableFuture<Tuple2<TransientBlobKey, Long>> load(FileReadDetail fd) throws Exception {
                return TaskManagerFileRangeHandler.this.loadTaskManagerFile(fd);
            }
        });
    }

    @Override
    protected CompletableFuture<LogDetail> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, FileRangeMessageParameters> handlerRequest, @Nonnull ResourceManagerGateway gateway) throws RestHandlerException {
        CompletableFuture blobKey2lengthFuture;
        Long fileReadCount;
        Long fileStart;
        String filename;
        ResourceID taskManagerId = (ResourceID)handlerRequest.getPathParameter(TaskManagerIdPathParameter.class);
        try {
            filename = (String)handlerRequest.getPathParameter(LogFileNamePathParameter.class);
        }
        catch (IllegalStateException e) {
            filename = null;
        }
        if (null == filename) {
            fileStart = null;
            fileReadCount = null;
        } else {
            List fileReadCountsTmp = handlerRequest.getQueryParameter(FileReadCountQueryParameter.class);
            fileReadCount = fileReadCountsTmp.isEmpty() ? FileOffsetRange.getSizeDefaultValue() : Math.abs((Long)fileReadCountsTmp.get(0));
            List fileReadStartsTmp = handlerRequest.getQueryParameter(FileReadStartQueryParameter.class);
            fileStart = fileReadStartsTmp.isEmpty() ? Long.valueOf(FileOffsetRange.getStartDefaultValue()) : (Long)fileReadStartsTmp.get(0);
        }
        FileReadDetail fd = new FileReadDetail(taskManagerId, filename, fileStart, fileReadCount);
        try {
            blobKey2lengthFuture = (CompletableFuture)this.fileBlobKey2lengths.get((Object)fd);
        }
        catch (ExecutionException e) {
            Throwable cause = ExceptionUtils.stripExecutionException((Throwable)e);
            if (cause instanceof RestHandlerException) {
                throw (RestHandlerException)((Object)cause);
            }
            throw new RestHandlerException("Could not retrieve file blob key future.", HttpResponseStatus.INTERNAL_SERVER_ERROR, e);
        }
        CompletionStage resultFuture = blobKey2lengthFuture.thenApplyAsync(blobKey2length -> {
            LogDetail logDetail;
            File file;
            try {
                file = this.transientBlobService.getFile((TransientBlobKey)blobKey2length.f0);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not retrieve file from transient blob store.", (Throwable)e));
            }
            try {
                String fileContent = FileUtils.readFileToString((File)file, (String)"UTF-8");
                logDetail = new LogDetail(fileContent, (Long)blobKey2length.f1);
            }
            catch (Exception e) {
                throw new CompletionException(new FlinkException("Could not transfer file to client.", (Throwable)e));
            }
            return logDetail;
        });
        return ((CompletableFuture)((CompletableFuture)resultFuture).thenApply(fileContent -> fileContent)).exceptionally(throwable -> {
            Throwable strippedThrowable = ExceptionUtils.stripExecutionException((Throwable)throwable);
            if (strippedThrowable instanceof UnknownTaskExecutorException) {
                throw new CompletionException((Throwable)((Object)new RestHandlerException("Could not find TaskExecutor " + taskManagerId + '.', HttpResponseStatus.NOT_FOUND, strippedThrowable)));
            }
            throw new CompletionException(strippedThrowable);
        });
    }

    protected abstract CompletableFuture<Tuple2<TransientBlobKey, Long>> requestTaskManagerFileUploadReturnLength(ResourceManagerGateway var1, FileReadDetail var2);

    private CompletableFuture<Tuple2<TransientBlobKey, Long>> loadTaskManagerFile(FileReadDetail fd) throws RestHandlerException {
        this.log.debug("Load file range from FileReadDetail:[{}].", (Object)fd);
        ResourceManagerGateway resourceManagerGateway = this.getResourceManagerGateway(this.resourceManagerGatewayRetriever);
        return this.requestTaskManagerFileUploadReturnLength(resourceManagerGateway, fd);
    }

    private void removeBlob(RemovalNotification<FileReadDetail, CompletableFuture<Tuple2<TransientBlobKey, Long>>> removalNotification) {
        this.log.debug("Remove cached file for TaskExecutor {}.", removalNotification.getKey());
        CompletableFuture value = (CompletableFuture)removalNotification.getValue();
        if (value != null) {
            value.thenAccept(blobKey2length -> this.transientBlobService.deleteFromCache((TransientBlobKey)blobKey2length.f0));
        }
    }
}

