/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.List;
import java.util.Objects;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class JobExceptionsInfo
implements ResponseBody {
    public static final String FIELD_NAME_ROOT_EXCEPTION = "root-exception";
    public static final String FIELD_NAME_TIMESTAMP = "timestamp";
    public static final String FIELD_NAME_ALL_EXCEPTIONS = "all-exceptions";
    public static final String FIELD_NAME_TRUNCATED = "truncated";
    @JsonProperty(value="root-exception")
    private final String rootException;
    @JsonProperty(value="timestamp")
    private final Long rootTimestamp;
    @JsonProperty(value="all-exceptions")
    private final List<ExecutionExceptionInfo> allExceptions;
    @JsonProperty(value="truncated")
    private final boolean truncated;

    @JsonCreator
    public JobExceptionsInfo(@JsonProperty(value="root-exception") String rootException, @JsonProperty(value="timestamp") Long rootTimestamp, @JsonProperty(value="all-exceptions") List<ExecutionExceptionInfo> allExceptions, @JsonProperty(value="truncated") boolean truncated) {
        this.rootException = rootException;
        this.rootTimestamp = rootTimestamp;
        this.allExceptions = (List)Preconditions.checkNotNull(allExceptions);
        this.truncated = truncated;
    }

    @JsonIgnore
    public List<ExecutionExceptionInfo> getAllExceptions() {
        return this.allExceptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobExceptionsInfo that = (JobExceptionsInfo)o;
        return this.truncated == that.truncated && Objects.equals(this.rootException, that.rootException) && Objects.equals(this.rootTimestamp, that.rootTimestamp) && Objects.equals(this.allExceptions, that.allExceptions);
    }

    public int hashCode() {
        return Objects.hash(this.rootException, this.rootTimestamp, this.allExceptions, this.truncated);
    }

    public static final class ExecutionExceptionInfo
    implements Comparable<ExecutionExceptionInfo> {
        public static final String FIELD_NAME_EXCEPTION = "exception";
        public static final String FIELD_NAME_TASK = "task";
        public static final String FIELD_NAME_LOCATION = "location";
        public static final String FIELD_NAME_TIMESTAMP = "timestamp";
        public static final String FIELD_NAME_VERTEX_ID = "vertex-id";
        public static final String FIELD_NAME_SUBTASK_INDEX = "subtask-index";
        public static final String FIELD_NAME_ATTEMPT_NUM = "attempt-num";
        @JsonProperty(value="exception")
        private final String exception;
        @JsonProperty(value="task")
        private final String task;
        @JsonProperty(value="location")
        private final String location;
        @JsonProperty(value="timestamp")
        private final long timestamp;
        @JsonProperty(value="vertex-id")
        private final String vertexID;
        @JsonProperty(value="subtask-index")
        private final int subtaskIndex;
        @JsonProperty(value="attempt-num")
        private final int attemptNum;

        @JsonCreator
        public ExecutionExceptionInfo(@JsonProperty(value="exception") String exception, @JsonProperty(value="task") String task, @JsonProperty(value="location") String location, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="vertex-id") String vertexID, @JsonProperty(value="subtask-index") int subtaskIndex, @JsonProperty(value="attempt-num") int attemptNum) {
            this.exception = (String)Preconditions.checkNotNull((Object)exception);
            this.task = (String)Preconditions.checkNotNull((Object)task);
            this.location = (String)Preconditions.checkNotNull((Object)location);
            this.timestamp = timestamp;
            this.vertexID = vertexID;
            this.subtaskIndex = subtaskIndex;
            this.attemptNum = attemptNum;
        }

        @JsonIgnore
        public String getException() {
            return this.exception;
        }

        @JsonIgnore
        public String getTask() {
            return this.task;
        }

        @JsonIgnore
        public String getLocation() {
            return this.location;
        }

        @JsonIgnore
        public long getTimestamp() {
            return this.timestamp;
        }

        @JsonIgnore
        public String getVertexID() {
            return this.vertexID;
        }

        @JsonIgnore
        public int getSubtaskIndex() {
            return this.subtaskIndex;
        }

        @JsonIgnore
        public int getAttemptNum() {
            return this.attemptNum;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionExceptionInfo that = (ExecutionExceptionInfo)o;
            return this.timestamp == that.timestamp && Objects.equals(this.exception, that.exception) && Objects.equals(this.task, that.task) && Objects.equals(this.location, that.location) && Objects.equals(this.vertexID, that.vertexID) && this.subtaskIndex == that.subtaskIndex && this.attemptNum == that.attemptNum;
        }

        public int hashCode() {
            return Objects.hash(this.timestamp, this.exception, this.task, this.location, this.vertexID, this.subtaskIndex, this.attemptNum);
        }

        @Override
        public int compareTo(ExecutionExceptionInfo o) {
            return Long.compare(this.timestamp, o.timestamp);
        }
    }
}

