/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.CommonExtendedResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class ResourceSpecInfo
implements ResponseBody,
Serializable {
    public static final String FIELD_NAME_CPU_CORE = "cpu-cores";
    public static final String FIELD_NAME_HEAP_MEMORY = "heap-memory";
    public static final String FIELD_NAME_DIRECT_MEMORY = "direct-memory";
    public static final String FIELD_NAME_NATIVE_MEMORY = "native-memory";
    public static final String FIELD_NAME_STATE_SIZE = "state-size";
    public static final String FIELD_NAME_EXTENDED_RESOURCES = "extended-resources";
    private static final long serialVersionUID = -6021783093094354286L;
    @JsonProperty(value="cpu-cores")
    private final double cpuCores;
    @JsonProperty(value="heap-memory")
    private final int heapMemoryInMB;
    @JsonProperty(value="direct-memory")
    private final int directMemoryInMB;
    @JsonProperty(value="native-memory")
    private final int nativeMemoryInMB;
    @JsonProperty(value="state-size")
    private final int stateSizeInMB;
    @JsonProperty(value="extended-resources")
    private final Map<String, ResourceInfo> extendedResources;

    @JsonCreator
    public ResourceSpecInfo(@JsonProperty(value="cpu-cores") double cpuCores, @JsonProperty(value="heap-memory") int heapMemoryInMB, @JsonProperty(value="direct-memory") int directMemoryInMB, @JsonProperty(value="native-memory") int nativeMemoryInMB, @JsonProperty(value="state-size") int stateSizeInMB, @JsonProperty(value="extended-resources") Map<String, ResourceInfo> extendedResources) {
        this.cpuCores = cpuCores;
        this.heapMemoryInMB = heapMemoryInMB;
        this.nativeMemoryInMB = nativeMemoryInMB;
        this.directMemoryInMB = directMemoryInMB;
        this.stateSizeInMB = stateSizeInMB;
        this.extendedResources = extendedResources;
    }

    @JsonIgnore
    public double getCpuCores() {
        return this.cpuCores;
    }

    @JsonIgnore
    public int getHeapMemoryInMB() {
        return this.heapMemoryInMB;
    }

    @JsonIgnore
    public int getDirectMemoryInMB() {
        return this.directMemoryInMB;
    }

    @JsonIgnore
    public int getNativeMemoryInMB() {
        return this.nativeMemoryInMB;
    }

    @JsonIgnore
    public int getStateSizeInMB() {
        return this.stateSizeInMB;
    }

    @JsonIgnore
    public Map<String, ResourceInfo> getExtendedResources() {
        return this.extendedResources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSpecInfo that = (ResourceSpecInfo)o;
        return this.cpuCores == that.cpuCores && this.heapMemoryInMB == that.heapMemoryInMB && this.directMemoryInMB == that.directMemoryInMB && this.nativeMemoryInMB == that.nativeMemoryInMB && this.stateSizeInMB == that.stateSizeInMB && Objects.equals(this.extendedResources, that.extendedResources);
    }

    public int hashCode() {
        return Objects.hash(this.cpuCores, this.heapMemoryInMB, this.directMemoryInMB, this.nativeMemoryInMB, this.stateSizeInMB, this.extendedResources);
    }

    public ResourceSpec convertToResourceSpec() {
        Resource[] resources;
        if (this.extendedResources != null && this.extendedResources.size() > 0) {
            List<Resource> resourcesTmp = this.extendedResources.values().stream().map(ResourceInfo::convertToResource).collect(Collectors.toList());
            resources = resourcesTmp.toArray(new Resource[this.extendedResources.size()]);
        } else {
            resources = new Resource[]{};
        }
        return ResourceSpec.newBuilder().setCpuCores(this.cpuCores).setHeapMemoryInMB(this.heapMemoryInMB).setDirectMemoryInMB(this.directMemoryInMB).setNativeMemoryInMB(this.nativeMemoryInMB).setStateSizeInMB(this.stateSizeInMB).addExtendedResource(resources).build();
    }

    public static final class ResourceInfo {
        public static final String FIELD_NAME_RESOURCE_NAME = "name";
        public static final String FIELD_NAME_RESOURCE_VALUE = "value";
        public static final String FIELD_NAME_RESOURCE_AGGREGATE_TYPE = "resource-aggregate-type";
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="value")
        private final Double value;
        @JsonProperty(value="resource-aggregate-type")
        private final Resource.ResourceAggregateType resourceAggregateType;

        @JsonCreator
        public ResourceInfo(@JsonProperty(value="name") String name, @JsonProperty(value="value") Double value, @JsonProperty(value="resource-aggregate-type") Resource.ResourceAggregateType resourceAggregateType) {
            this.name = name;
            this.value = value;
            this.resourceAggregateType = resourceAggregateType;
        }

        public ResourceInfo(Resource resource) {
            this.name = resource.getName();
            this.value = resource.getValue();
            this.resourceAggregateType = resource.getResourceAggregateType();
        }

        @JsonIgnore
        public String getName() {
            return this.name;
        }

        @JsonIgnore
        public Double getValue() {
            return this.value;
        }

        @JsonIgnore
        public Resource.ResourceAggregateType getResourceAggregateType() {
            return this.resourceAggregateType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceInfo that = (ResourceInfo)o;
            return Objects.equals(this.name, that.name) && this.value == that.value && Objects.equals(this.resourceAggregateType, that.resourceAggregateType);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value, this.resourceAggregateType);
        }

        public Resource convertToResource() {
            return new CommonExtendedResource(this.name, this.value.doubleValue(), this.resourceAggregateType);
        }
    }
}

