/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDSerializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexOperatorIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexOperatorIDSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

public class JobVerticesInfo
implements ResponseBody {
    public static final String FIELD_NAME_JOB_VERTICES = "vertices";
    public static final String FIELD_NAME_JOB_OPERATOR = "operators";
    @JsonProperty(value="vertices")
    private final Collection<JobVertex> jobVertices;
    @JsonProperty(value="operators")
    private final Collection<JobOperator> jobOperators;

    @JsonCreator
    public JobVerticesInfo(@JsonProperty(value="vertices") Collection<JobVertex> jobVertices, @JsonProperty(value="operators") Collection<JobOperator> jobOperators) {
        this.jobVertices = (Collection)Preconditions.checkNotNull(jobVertices);
        this.jobOperators = (Collection)Preconditions.checkNotNull(jobOperators);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobVerticesInfo that = (JobVerticesInfo)o;
        return Objects.equals(this.jobVertices, that.jobVertices) && Objects.equals(this.jobOperators, that.jobOperators);
    }

    public int hashCode() {
        return Objects.hash(this.jobVertices, this.jobOperators);
    }

    @JsonIgnore
    public Collection<JobVertex> getJobVertices() {
        return this.jobVertices;
    }

    @JsonIgnore
    public Collection<JobOperator> getJobOperators() {
        return this.jobOperators;
    }

    public static final class OperatorEdgeInfo {
        public static final String FIELD_NAME_VERTEX_OPERATOR_EDG_TARGET_ID = "operator_id";
        public static final String FIELD_NAME_VERTEX_OPERATOR_EDG_PARTITIONER = "partitioner";
        public static final String FIELD_NAME_VERTEX_OPERATOR_EDG_TYPE_NUMBER = "type_number";
        @JsonProperty(value="operator_id")
        @JsonSerialize(using=JobVertexOperatorIDSerializer.class)
        private final OperatorID jobVertexOperatorID;
        @JsonProperty(value="partitioner")
        private final String partitioner;
        @JsonProperty(value="type_number")
        private final int typeNumber;

        @JsonCreator
        public OperatorEdgeInfo(@JsonDeserialize(using=JobVertexOperatorIDDeserializer.class) @JsonProperty(value="operator_id") OperatorID jobVertexOperatorID, @JsonProperty(value="partitioner") String partitioner, @JsonProperty(value="type_number") int typeNumber) {
            this.jobVertexOperatorID = (OperatorID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexOperatorID)));
            this.partitioner = (String)Preconditions.checkNotNull((Object)partitioner);
            this.typeNumber = typeNumber;
        }

        @JsonIgnore
        public OperatorID getJobVertexOperatorID() {
            return this.jobVertexOperatorID;
        }

        @JsonIgnore
        public String getPartitioner() {
            return this.partitioner;
        }

        @JsonIgnore
        public int getTypeNumber() {
            return this.typeNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorEdgeInfo that = (OperatorEdgeInfo)o;
            return Objects.equals((Object)this.jobVertexOperatorID, (Object)that.jobVertexOperatorID) && Objects.equals(this.partitioner, that.partitioner) && Objects.equals(this.typeNumber, that.typeNumber);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.jobVertexOperatorID, this.partitioner, this.typeNumber});
        }
    }

    public static final class JobOperator {
        public static final String FIELD_NAME_VERTEX_VERTEX_ID = "vertex_id";
        public static final String FIELD_NAME_VERTEX_OPERATOR_ID = "operator_id";
        public static final String FIELD_NAME_VERTEX_OPERATOR_NAME = "name";
        public static final String FIELD_NAME_VERTEX_OPERATOR_INPUTS = "inputs";
        public static final String FIELD_NAME_VERTEX_OPERATOR_METRIC_NAME = "metric_name";
        @JsonProperty(value="vertex_id")
        @JsonSerialize(using=JobVertexIDSerializer.class)
        private final JobVertexID jobVertexID;
        @JsonProperty(value="operator_id")
        @JsonSerialize(using=JobVertexOperatorIDSerializer.class)
        private final OperatorID jobVertexOperatorID;
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="inputs")
        private final Collection<OperatorEdgeInfo> inputs;
        @JsonProperty(value="metric_name")
        private final String metricName;

        @JsonCreator
        public JobOperator(@JsonDeserialize(using=JobVertexIDDeserializer.class) @JsonProperty(value="vertex_id") JobVertexID jobVertexID, @JsonDeserialize(using=JobVertexOperatorIDDeserializer.class) @JsonProperty(value="operator_id") OperatorID jobVertexOperatorID, @JsonProperty(value="name") String name, @JsonProperty(value="inputs") Collection<OperatorEdgeInfo> inputs, @JsonProperty(value="metric_name") String metricName) {
            this.jobVertexOperatorID = (OperatorID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexOperatorID)));
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.inputs = inputs;
            this.metricName = metricName;
            this.jobVertexID = jobVertexID;
        }

        @JsonIgnore
        public JobVertexID getJobVertexID() {
            return this.jobVertexID;
        }

        @JsonIgnore
        public OperatorID getJobVertexOperatorID() {
            return this.jobVertexOperatorID;
        }

        @JsonIgnore
        public String getName() {
            return this.name;
        }

        @JsonIgnore
        public Collection<OperatorEdgeInfo> getInputs() {
            return this.inputs;
        }

        @JsonIgnore
        public String getMetricName() {
            return this.metricName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobOperator that = (JobOperator)o;
            return Objects.equals((Object)this.jobVertexID, (Object)that.jobVertexID) && Objects.equals((Object)this.jobVertexOperatorID, (Object)that.jobVertexOperatorID) && Objects.equals(this.name, that.name) && Objects.equals(this.inputs, that.inputs) && Objects.equals(this.metricName, that.metricName);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.jobVertexID, this.jobVertexOperatorID, this.name, this.inputs, this.metricName});
        }
    }

    public static final class JobVertex {
        public static final String FIELD_NAME_JOB_VERTEX_ID = "id";
        public static final String FIELD_NAME_JOB_VERTEX_NAME = "name";
        public static final String FIELD_NAME_JOB_VERTEX_PARALLELISM = "parallelism";
        public static final String FIELD_NAME_JOB_VERTEX_SUBTASK_METRICS = "subtask_metrics";
        public static final String FIELD_NAME_JOB_VERTEX_METRICS = "metrics";
        @JsonProperty(value="id")
        @JsonSerialize(using=JobVertexIDSerializer.class)
        private final JobVertexID jobVertexID;
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="parallelism")
        private final int parallelism;
        @JsonProperty(value="subtask_metrics")
        private final Collection<Map<String, String>> jobVertexSubTaskMetrics;
        @JsonProperty(value="metrics")
        private final IOMetricsInfo jobVertexMetrics;

        @JsonCreator
        public JobVertex(@JsonDeserialize(using=JobVertexIDDeserializer.class) @JsonProperty(value="id") JobVertexID jobVertexID, @JsonProperty(value="name") String name, @JsonProperty(value="parallelism") int parallelism, @JsonProperty(value="subtask_metrics") Collection<Map<String, String>> jobVertexSubTaskMetrics, @JsonProperty(value="metrics") IOMetricsInfo jobVertexMetrics) {
            this.jobVertexID = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexID)));
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.parallelism = parallelism;
            this.jobVertexSubTaskMetrics = (Collection)Preconditions.checkNotNull(jobVertexSubTaskMetrics);
            this.jobVertexMetrics = (IOMetricsInfo)Preconditions.checkNotNull((Object)jobVertexMetrics);
        }

        @JsonIgnore
        public JobVertexID getJobVertexID() {
            return this.jobVertexID;
        }

        @JsonIgnore
        public String getName() {
            return this.name;
        }

        @JsonIgnore
        public int getParallelism() {
            return this.parallelism;
        }

        @JsonIgnore
        public Collection<Map<String, String>> getJobVertexSubTaskMetrics() {
            return this.jobVertexSubTaskMetrics;
        }

        @JsonIgnore
        public IOMetricsInfo getJobVertexMetrics() {
            return this.jobVertexMetrics;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobVertex that = (JobVertex)o;
            return Objects.equals((Object)this.jobVertexID, (Object)that.jobVertexID) && Objects.equals(this.name, that.name) && this.parallelism == that.parallelism && Objects.equals(this.jobVertexSubTaskMetrics, that.jobVertexSubTaskMetrics) && Objects.equals(this.jobVertexMetrics, that.jobVertexMetrics);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.jobVertexID, this.name, this.parallelism, this.jobVertexSubTaskMetrics, this.jobVertexMetrics});
        }
    }
}

