/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job.metrics;

import java.util.Locale;
import org.apache.flink.runtime.rest.messages.ConversionException;
import org.apache.flink.runtime.rest.messages.MessageParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;

public class MetricsAggregationParameter
extends MessageQueryParameter<AggregationMode> {
    protected MetricsAggregationParameter() {
        super("agg", MessageParameter.MessageParameterRequisiteness.OPTIONAL);
    }

    @Override
    public AggregationMode convertStringToValue(String value) throws ConversionException {
        try {
            return AggregationMode.valueOf(value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("Not a valid aggregation: " + value, iae);
        }
    }

    @Override
    public String convertValueToString(AggregationMode value) {
        return value.name().toLowerCase();
    }

    public static enum AggregationMode {
        MIN,
        MAX,
        SUM,
        AVG;

    }
}

