/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.schedule;

import java.io.Serializable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.schedule.EagerSchedulingPlugin;
import org.apache.flink.runtime.schedule.GraphManagerPlugin;
import org.apache.flink.runtime.schedule.StepwiseSchedulingPlugin;

public class GraphManagerPluginFactory
implements Serializable {
    private static final long serialVersionUID = 7967476136812239100L;

    public static GraphManagerPlugin createGraphManagerPlugin(Configuration configuration, ClassLoader classLoader) {
        GraphManagerPlugin graphManagerPlugin;
        String graphManagerPluginClassName = configuration.getString(JobManagerOptions.GRAPH_MANAGER_PLUGIN);
        if (graphManagerPluginClassName == null) {
            ScheduleMode scheduleMode = ScheduleMode.valueOf(configuration.getString(ScheduleMode.class.getName(), ScheduleMode.LAZY_FROM_SOURCES.toString()));
            switch (scheduleMode) {
                case EAGER: {
                    graphManagerPlugin = new EagerSchedulingPlugin();
                    break;
                }
                case LAZY_FROM_SOURCES: {
                    graphManagerPlugin = new StepwiseSchedulingPlugin();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown schedule mode: " + (Object)((Object)scheduleMode));
                }
            }
        } else {
            try {
                Class<GraphManagerPlugin> clazz = Class.forName(graphManagerPluginClassName, false, classLoader).asSubclass(GraphManagerPlugin.class);
                graphManagerPlugin = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot find configured graph manager plugin class: " + graphManagerPluginClassName, e);
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("The class configured under '" + JobManagerOptions.GRAPH_MANAGER_PLUGIN.key() + "' is not a valid graph manager plugin(" + graphManagerPluginClassName + ')', e);
            }
        }
        return graphManagerPlugin;
    }
}

