/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.IncrementalStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalKeyedStateSnapshot
implements KeyedStateHandle,
IncrementalStateHandle {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalKeyedStateHandle.class);
    private static final long serialVersionUID = 1L;
    private final long checkpointId;
    private final Map<StateHandleID, Tuple2<String, StreamStateHandle>> sharedState;
    private final Map<StateHandleID, StreamStateHandle> privateState;
    private final KeyGroupRange keyGroupRange;
    @Nonnull
    private final StreamStateHandle metaStateHandle;
    private transient SharedStateRegistry sharedStateRegistry;

    public IncrementalKeyedStateSnapshot(KeyGroupRange keyGroupRange, long checkpointId, Map<StateHandleID, Tuple2<String, StreamStateHandle>> sharedState, Map<StateHandleID, StreamStateHandle> privateState, StreamStateHandle metaStateHandle) {
        this.keyGroupRange = keyGroupRange;
        this.checkpointId = checkpointId;
        this.sharedState = sharedState;
        this.privateState = privateState;
        this.sharedStateRegistry = null;
        this.metaStateHandle = metaStateHandle;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public Map<StateHandleID, Tuple2<String, StreamStateHandle>> getSharedState() {
        return this.sharedState;
    }

    public Map<StateHandleID, StreamStateHandle> getPrivateState() {
        return this.privateState;
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    public KeyedStateHandle getIntersection(KeyGroupRange otherKeyGroupRange) {
        return KeyGroupRange.EMPTY_KEY_GROUP_RANGE.equals(this.keyGroupRange.getIntersection(otherKeyGroupRange)) ? null : this;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
        Preconditions.checkState((this.sharedStateRegistry != stateRegistry ? 1 : 0) != 0, (Object)"The state handle has already registered its shared states to the given registry.");
        this.sharedStateRegistry = (SharedStateRegistry)Preconditions.checkNotNull((Object)stateRegistry);
        LOG.trace("Registering IncrementalKeyedStateSnapshot for checkpoint {} from backend.", (Object)this.checkpointId);
        for (Map.Entry<StateHandleID, Tuple2<String, StreamStateHandle>> sharedStateHandle : this.sharedState.entrySet()) {
            String uniqueId = (String)sharedStateHandle.getValue().f0;
            SharedStateRegistryKey registryKey = this.createSharedStateRegistryKeyFromUniqueId(uniqueId, sharedStateHandle.getKey());
            SharedStateRegistry.Result result = stateRegistry.registerReference(registryKey, (StreamStateHandle)sharedStateHandle.getValue().f1);
            sharedStateHandle.setValue((Tuple2<String, StreamStateHandle>)Tuple2.of((Object)uniqueId, (Object)result.getReference()));
        }
    }

    @Override
    public void discardState() throws Exception {
        SharedStateRegistry registry = this.sharedStateRegistry;
        boolean isRegistered = registry != null;
        LOG.trace("Discarding IncrementalKeyedStateSnapshot (registered = {}) for checkpoint {} from backend.", (Object)isRegistered, (Object)this.checkpointId);
        try {
            this.metaStateHandle.discardState();
        }
        catch (Exception e) {
            LOG.warn("Could not properly discard meta data.", (Throwable)e);
        }
        try {
            StateUtil.bestEffortDiscardAllStateObjects(this.privateState.values());
        }
        catch (Exception e) {
            LOG.warn("Could not properly discard misc file states.", (Throwable)e);
        }
        if (isRegistered) {
            for (Map.Entry<StateHandleID, Tuple2<String, StreamStateHandle>> entry : this.sharedState.entrySet()) {
                registry.unregisterReference(this.createSharedStateRegistryKeyFromUniqueId((String)entry.getValue().f0, entry.getKey()));
            }
        } else {
            try {
                StateUtil.bestEffortDiscardAllStateObjects(this.sharedState.values().stream().map(t -> (StreamStateHandle)t.f1).collect(Collectors.toSet()));
            }
            catch (Exception e) {
                LOG.warn("Could not properly discard new sst file states.", (Throwable)e);
            }
        }
    }

    @Override
    public long getStateSize() {
        long size = StateUtil.getStateSize(this.metaStateHandle);
        for (Tuple2<String, StreamStateHandle> sharedStateHandle : this.sharedState.values()) {
            size += ((StreamStateHandle)sharedStateHandle.f1).getStateSize();
        }
        for (StreamStateHandle privateStateHandle : this.privateState.values()) {
            size += privateStateHandle.getStateSize();
        }
        return size;
    }

    @Override
    public long getFullStateSize() {
        long fullSize = StateUtil.getStateSize(this.metaStateHandle);
        for (Tuple2<String, StreamStateHandle> sharedStateHandle : this.sharedState.values()) {
            if (sharedStateHandle.f1 instanceof IncrementalStateHandle) {
                fullSize += ((IncrementalStateHandle)sharedStateHandle.f1).getFullStateSize();
                continue;
            }
            fullSize += ((StreamStateHandle)sharedStateHandle.f1).getStateSize();
        }
        for (StreamStateHandle privateStateHandle : this.privateState.values()) {
            fullSize += privateStateHandle.getStateSize();
        }
        return fullSize;
    }

    @Nonnull
    public StreamStateHandle getMetaStateHandle() {
        return this.metaStateHandle;
    }

    @VisibleForTesting
    public SharedStateRegistryKey createSharedStateRegistryKeyFromUniqueId(String uniqueId, StateHandleID shId) {
        return new SharedStateRegistryKey(uniqueId, shId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncrementalKeyedStateSnapshot that = (IncrementalKeyedStateSnapshot)o;
        if (this.getCheckpointId() != that.getCheckpointId()) {
            return false;
        }
        if (!this.keyGroupRange.equals(that.getKeyGroupRange())) {
            return false;
        }
        if (!this.getSharedState().equals(that.getSharedState())) {
            return false;
        }
        if (!this.getPrivateState().equals(that.getPrivateState())) {
            return false;
        }
        return this.getMetaStateHandle().equals(that.getMetaStateHandle());
    }

    public int hashCode() {
        int result = this.getKeyGroupRange().hashCode();
        result = 31 * result + (int)(this.getCheckpointId() ^ this.getCheckpointId() >>> 32);
        result = 31 * result + this.getSharedState().hashCode();
        result = 31 * result + this.getPrivateState().hashCode();
        result = 31 * result + this.getMetaStateHandle().hashCode();
        return result;
    }
}

