/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.DirectoryKeyedStateHandle;
import org.apache.flink.runtime.state.DirectoryStateHandle;
import org.apache.flink.runtime.state.IncrementalLocalKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.ExceptionUtils;

public class IncrementalLocalKeyedStateSnapshot
extends DirectoryKeyedStateHandle {
    private static final long serialVersionUID = 1L;
    @Nonnegative
    private final long checkpointId;
    @Nonnull
    private final StreamStateHandle metaStateHandle;
    @Nonnull
    private final Map<StateHandleID, Tuple2<String, StreamStateHandle>> sharedStateHandles;

    public IncrementalLocalKeyedStateSnapshot(@Nonnull KeyGroupRange keyGroupRange, @Nonnegative long checkpointId, @Nonnull StreamStateHandle metaStateHandle, @Nonnull DirectoryStateHandle directoryStateHandle, @Nonnull Map<StateHandleID, Tuple2<String, StreamStateHandle>> sharedStateHandles) {
        super(directoryStateHandle, keyGroupRange);
        this.checkpointId = checkpointId;
        this.metaStateHandle = metaStateHandle;
        this.sharedStateHandles = sharedStateHandles;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    @Nonnull
    public StreamStateHandle getMetaStateHandle() {
        return this.metaStateHandle;
    }

    @Nonnull
    public Map<StateHandleID, Tuple2<String, StreamStateHandle>> getSharedStateHandles() {
        return this.sharedStateHandles;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IncrementalLocalKeyedStateHandle that = (IncrementalLocalKeyedStateHandle)o;
        if (!this.getSharedStateHandles().equals(that.getSharedStateHandleIDs())) {
            return false;
        }
        return this.getMetaStateHandle().equals(that.getMetaDataState());
    }

    @Override
    public void discardState() throws Exception {
        Exception collectedEx = null;
        try {
            super.discardState();
        }
        catch (Exception e) {
            collectedEx = e;
        }
        try {
            this.metaStateHandle.discardState();
        }
        catch (Exception e) {
            collectedEx = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)collectedEx);
        }
        if (collectedEx != null) {
            throw collectedEx;
        }
    }

    @Override
    public long getStateSize() {
        return super.getStateSize() + this.metaStateHandle.getStateSize();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getMetaStateHandle().hashCode();
        result = 31 * result + this.getSharedStateHandles().hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "IncrementalLocalKeyedStateSnapshot{metaStateHandle=" + this.metaStateHandle + "keyGroupRange=" + this.getKeyGroupRange() + "} " + super.toString();
    }
}

