/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.InternalStateType;
import org.apache.flink.runtime.state.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.util.Preconditions;

public class InternalBackendSerializationProxy
extends VersionedIOReadableWritable {
    public static final int VERSION = 1;
    private boolean usingKeyGroupCompression;
    private boolean isSerializerPresenceRequired;
    private List<StateMetaInfoSnapshot> keyedStateMetaInfoSnapshots;
    private List<StateMetaInfoSnapshot> subKeyedStateMetaInfoSnapshots;
    private ClassLoader userCodeClassLoader;

    public InternalBackendSerializationProxy(ClassLoader userCodeClassLoader, boolean isSerializerPresenceRequired) {
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
        this.isSerializerPresenceRequired = isSerializerPresenceRequired;
    }

    public InternalBackendSerializationProxy(List<StateMetaInfoSnapshot> keyedStateMetaSnapshots, List<StateMetaInfoSnapshot> subKeyedStateMetaSnapshots, boolean compression) {
        this.keyedStateMetaInfoSnapshots = (List)Preconditions.checkNotNull(keyedStateMetaSnapshots);
        this.subKeyedStateMetaInfoSnapshots = (List)Preconditions.checkNotNull(subKeyedStateMetaSnapshots);
        this.usingKeyGroupCompression = compression;
    }

    public List<StateMetaInfoSnapshot> getKeyedStateMetaSnapshots() {
        return this.keyedStateMetaInfoSnapshots;
    }

    public List<StateMetaInfoSnapshot> getSubKeyedStateMetaSnapshots() {
        return this.subKeyedStateMetaInfoSnapshots;
    }

    public boolean isUsingKeyGroupCompression() {
        return this.usingKeyGroupCompression;
    }

    public int getVersion() {
        return 1;
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeBoolean(this.usingKeyGroupCompression);
        this.writeStateMetaInfoSnapshot(out, this.keyedStateMetaInfoSnapshots, true);
        this.writeStateMetaInfoSnapshot(out, this.subKeyedStateMetaInfoSnapshots, false);
    }

    private void writeStateMetaInfoSnapshot(DataOutputView out, List<StateMetaInfoSnapshot> stateMetaInfoSnapshots, boolean isKeyedState) throws IOException {
        out.writeShort(stateMetaInfoSnapshots.size());
        for (StateMetaInfoSnapshot stateMetaInfoSnapshot : stateMetaInfoSnapshots) {
            out.writeInt(stateMetaInfoSnapshot.getStateType().ordinal());
            out.writeUTF(stateMetaInfoSnapshot.getName());
            if (isKeyedState) {
                TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience((DataOutputView)out, Arrays.asList(new Tuple2((Object)stateMetaInfoSnapshot.getKeySerializer(), (Object)stateMetaInfoSnapshot.getKeySerializerConfigSnapshot()), new Tuple2((Object)stateMetaInfoSnapshot.getValueSerializer(), (Object)stateMetaInfoSnapshot.getValueSerializerConfigSnapshot())));
                continue;
            }
            TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience((DataOutputView)out, Arrays.asList(new Tuple2((Object)stateMetaInfoSnapshot.getKeySerializer(), (Object)stateMetaInfoSnapshot.getKeySerializerConfigSnapshot()), new Tuple2((Object)stateMetaInfoSnapshot.getValueSerializer(), (Object)stateMetaInfoSnapshot.getValueSerializerConfigSnapshot()), new Tuple2((Object)stateMetaInfoSnapshot.getNamespaceSerializer(), (Object)stateMetaInfoSnapshot.getNamespaceSerializerConfigSnapshot())));
        }
    }

    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.usingKeyGroupCompression = in.readBoolean();
        this.keyedStateMetaInfoSnapshots = this.readStateMetaInfoSnapshot(in, true);
        this.subKeyedStateMetaInfoSnapshots = this.readStateMetaInfoSnapshot(in, false);
    }

    private List<StateMetaInfoSnapshot> readStateMetaInfoSnapshot(DataInputView in, boolean isKeyedState) throws IOException {
        int stateSize = in.readShort();
        ArrayList<StateMetaInfoSnapshot> stateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>();
        for (int i = 0; i < stateSize; ++i) {
            Tuple2 namespaceSerializerInfo;
            Tuple2 valueSerializerInfo;
            Tuple2 keySerializerInfo;
            InternalStateType stateType = InternalStateType.values()[in.readInt()];
            String stateName = in.readUTF();
            List serializersAndConfigs = TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)in, (ClassLoader)this.userCodeClassLoader);
            if (isKeyedState) {
                Preconditions.checkState((serializersAndConfigs.size() == 2 ? 1 : 0) != 0, (Object)"Expected serialized serializer and config size as 2 for keyed state");
                Preconditions.checkState((boolean)stateType.isKeyedState(), (Object)"Expected keyed state here.");
                keySerializerInfo = (Tuple2)serializersAndConfigs.get(0);
                valueSerializerInfo = (Tuple2)serializersAndConfigs.get(1);
                namespaceSerializerInfo = null;
                stateMetaInfoSnapshots.add(new StateMetaInfoSnapshot(stateType, stateName, (TypeSerializer)keySerializerInfo.f0, (TypeSerializer)valueSerializerInfo.f0, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (TypeSerializerConfigSnapshot)keySerializerInfo.f1, (TypeSerializerConfigSnapshot)valueSerializerInfo.f1, VoidNamespaceSerializer.SNAPSHOT));
            } else {
                Preconditions.checkState((serializersAndConfigs.size() == 3 ? 1 : 0) != 0, (Object)"Expected serialized serializer and config size as 3 for subKeyed state.");
                Preconditions.checkState((!stateType.isKeyedState() ? 1 : 0) != 0, (Object)"Expected subKeyed state here.");
                keySerializerInfo = (Tuple2)serializersAndConfigs.get(0);
                valueSerializerInfo = (Tuple2)serializersAndConfigs.get(1);
                namespaceSerializerInfo = (Tuple2)serializersAndConfigs.get(2);
                stateMetaInfoSnapshots.add(new StateMetaInfoSnapshot(stateType, stateName, (TypeSerializer)keySerializerInfo.f0, (TypeSerializer)valueSerializerInfo.f0, (TypeSerializer)namespaceSerializerInfo.f0, (TypeSerializerConfigSnapshot)keySerializerInfo.f1, (TypeSerializerConfigSnapshot)valueSerializerInfo.f1, (TypeSerializerConfigSnapshot)namespaceSerializerInfo.f1));
            }
            if (!this.isSerializerPresenceRequired) continue;
            this.checkSerializerPresence((TypeSerializer)keySerializerInfo.f0);
            this.checkSerializerPresence((TypeSerializer)valueSerializerInfo.f0);
            if (namespaceSerializerInfo == null) continue;
            this.checkSerializerPresence((TypeSerializer)namespaceSerializerInfo.f0);
        }
        return stateMetaInfoSnapshots;
    }

    public int[] getCompatibleVersions() {
        return new int[]{1};
    }

    private void checkSerializerPresence(TypeSerializer<?> serializer) throws IOException {
        if (serializer instanceof UnloadableDummyTypeSerializer) {
            throw new IOException("Unable to restore keyed state, because a previous serializer of the keyed state is not present The serializer could have been removed from the classpath,  or its implementation have changed and could not be loaded. This is a temporary restriction that will be fixed in future versions.");
        }
    }
}

