/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.functions.Comparator;
import org.apache.flink.api.common.functions.Merger;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

public class InternalColumnDescriptor<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final TypeSerializer<T> serializer;
    @Nullable
    private final Comparator<T> comparator;
    @Nullable
    private final Merger<T> merger;

    public InternalColumnDescriptor(String name, TypeSerializer<T> serializer) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(serializer);
        this.name = name;
        this.serializer = serializer;
        this.comparator = null;
        this.merger = null;
    }

    public InternalColumnDescriptor(String name, TypeSerializer<T> serializer, Comparator<T> comparator) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(serializer);
        Preconditions.checkNotNull(comparator);
        this.name = name;
        this.serializer = serializer;
        this.comparator = comparator;
        this.merger = null;
    }

    public InternalColumnDescriptor(String name, TypeSerializer<T> serializer, Merger<T> merger) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(serializer);
        Preconditions.checkNotNull(merger);
        this.name = name;
        this.serializer = serializer;
        this.merger = merger;
        this.comparator = null;
    }

    public String getName() {
        return this.name;
    }

    public TypeSerializer<T> getSerializer() {
        return this.serializer;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public Merger<T> getMerger() {
        return this.merger;
    }

    public boolean isOrdered() {
        return this.comparator != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalColumnDescriptor that = (InternalColumnDescriptor)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.serializer, that.serializer) && Objects.equals(this.comparator, that.comparator) && Objects.equals(this.merger, that.merger);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.serializer);
        result = 31 * result + Objects.hashCode(this.comparator);
        result = 31 * result + Objects.hashCode(this.merger);
        return result;
    }

    public String toString() {
        return "InternalColumnDescriptor{name=" + this.name + ", serializer=" + this.serializer + ", comparator=" + this.comparator + ", merger=" + this.merger + "}";
    }
}

