/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public final class KeyGroupsStateSnapshot
implements StreamStateHandle,
KeyedStateHandle {
    private static final long serialVersionUID = 1L;
    private final KeyGroupRange keyGroupRange;
    private final Map<Integer, Tuple2<Long, Integer>> metaInfos;
    @Nullable
    private final StreamStateHandle snapshotHandle;

    public KeyGroupsStateSnapshot(KeyGroupRange keyGroupRange, Map<Integer, Tuple2<Long, Integer>> metaInfos, StreamStateHandle snapshotHandle) {
        Preconditions.checkNotNull((Object)keyGroupRange);
        Preconditions.checkNotNull(metaInfos);
        Preconditions.checkNotNull((Object)snapshotHandle);
        this.keyGroupRange = keyGroupRange;
        this.metaInfos = metaInfos;
        this.snapshotHandle = snapshotHandle;
    }

    public KeyGroupsStateSnapshot(KeyGroupRange keyGroupRange) {
        Preconditions.checkNotNull((Object)keyGroupRange);
        this.keyGroupRange = keyGroupRange;
        this.metaInfos = Collections.emptyMap();
        this.snapshotHandle = null;
    }

    public Map<Integer, Tuple2<Long, Integer>> getMetaInfos() {
        return this.metaInfos;
    }

    public StreamStateHandle getSnapshotHandle() {
        return this.snapshotHandle;
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    public KeyedStateHandle getIntersection(KeyGroupRange otherKeyGroupRange) {
        Preconditions.checkNotNull((Object)otherKeyGroupRange);
        KeyGroupRange intersectGroups = this.keyGroupRange.getIntersection(otherKeyGroupRange);
        if (this.snapshotHandle == null) {
            return new KeyGroupsStateSnapshot(intersectGroups);
        }
        HashMap<Integer, Tuple2<Long, Integer>> intersectMetaInfos = new HashMap<Integer, Tuple2<Long, Integer>>();
        for (int group : intersectGroups) {
            Tuple2<Long, Integer> metaInfo = this.metaInfos.get(group);
            if (metaInfo == null) continue;
            intersectMetaInfos.put(group, metaInfo);
        }
        return new KeyGroupsStateSnapshot(intersectGroups, intersectMetaInfos, this.snapshotHandle);
    }

    @Override
    public void discardState() throws Exception {
        if (this.snapshotHandle != null) {
            this.snapshotHandle.discardState();
        }
    }

    @Override
    public long getStateSize() {
        return this.snapshotHandle == null ? 0L : this.snapshotHandle.getStateSize();
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
    }

    public long getOffsetForKeyGroup(int keyGroupId) {
        if (!this.metaInfos.containsKey(keyGroupId)) {
            System.out.println();
        }
        return (Long)this.metaInfos.get((Object)Integer.valueOf((int)keyGroupId)).f0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyGroupsStateSnapshot that = (KeyGroupsStateSnapshot)o;
        return Objects.equals(this.keyGroupRange, that.keyGroupRange) && Objects.equals(this.metaInfos, that.metaInfos) && Objects.equals(this.snapshotHandle, that.snapshotHandle);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.keyGroupRange);
        result = 31 * result + Objects.hashCode(this.metaInfos);
        result = 31 * result + Objects.hashCode(this.snapshotHandle);
        return result;
    }

    public String toString() {
        return "KeyGroupsStateSnapshot{keyGroupRange=" + this.keyGroupRange + ", metaInfos=" + this.metaInfos + ", snapshotHandle=" + this.snapshotHandle + "}";
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        Preconditions.checkNotNull((Object)this.snapshotHandle, (String)"snapshotHandle is null");
        return this.snapshotHandle.openInputStream();
    }
}

