/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.OperatorBackendStateMetaInfoSnapshotReaderWriters;
import org.apache.flink.runtime.state.RegisteredBroadcastBackendStateMetaInfo;
import org.apache.flink.runtime.state.RegisteredOperatorBackendStateMetaInfo;
import org.apache.flink.util.Preconditions;

public class OperatorBackendSerializationProxy
extends VersionedIOReadableWritable {
    public static final int VERSION = 3;
    private List<RegisteredOperatorBackendStateMetaInfo.Snapshot<?>> operatorStateMetaInfoSnapshots;
    private List<RegisteredBroadcastBackendStateMetaInfo.Snapshot<?, ?>> broadcastStateMetaInfoSnapshots;
    private ClassLoader userCodeClassLoader;

    public OperatorBackendSerializationProxy(ClassLoader userCodeClassLoader) {
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
    }

    public OperatorBackendSerializationProxy(List<RegisteredOperatorBackendStateMetaInfo.Snapshot<?>> operatorStateMetaInfoSnapshots, List<RegisteredBroadcastBackendStateMetaInfo.Snapshot<?, ?>> broadcastStateMetaInfoSnapshots) {
        this.operatorStateMetaInfoSnapshots = (List)Preconditions.checkNotNull(operatorStateMetaInfoSnapshots);
        this.broadcastStateMetaInfoSnapshots = (List)Preconditions.checkNotNull(broadcastStateMetaInfoSnapshots);
        Preconditions.checkArgument((operatorStateMetaInfoSnapshots.size() <= Short.MAX_VALUE && broadcastStateMetaInfoSnapshots.size() <= Short.MAX_VALUE ? 1 : 0) != 0);
    }

    public int getVersion() {
        return 3;
    }

    public int[] getCompatibleVersions() {
        return new int[]{3, 2, 1};
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeShort(this.operatorStateMetaInfoSnapshots.size());
        for (RegisteredOperatorBackendStateMetaInfo.Snapshot<?> snapshot : this.operatorStateMetaInfoSnapshots) {
            OperatorBackendStateMetaInfoSnapshotReaderWriters.getOperatorStateWriterForVersion(3, snapshot).writeOperatorStateMetaInfo(out);
        }
        out.writeShort(this.broadcastStateMetaInfoSnapshots.size());
        for (RegisteredBroadcastBackendStateMetaInfo.Snapshot snapshot : this.broadcastStateMetaInfoSnapshots) {
            OperatorBackendStateMetaInfoSnapshotReaderWriters.getBroadcastStateWriterForVersion(3, snapshot).writeBroadcastStateMetaInfo(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        super.read(in);
        int numOperatorStates = in.readShort();
        this.operatorStateMetaInfoSnapshots = new ArrayList(numOperatorStates);
        for (int i = 0; i < numOperatorStates; ++i) {
            this.operatorStateMetaInfoSnapshots.add(OperatorBackendStateMetaInfoSnapshotReaderWriters.getOperatorStateReaderForVersion(this.getReadVersion(), this.userCodeClassLoader).readOperatorStateMetaInfo(in));
        }
        if (this.getReadVersion() >= 3) {
            int numBroadcastStates = in.readShort();
            this.broadcastStateMetaInfoSnapshots = new ArrayList(numBroadcastStates);
            for (int i = 0; i < numBroadcastStates; ++i) {
                this.broadcastStateMetaInfoSnapshots.add(OperatorBackendStateMetaInfoSnapshotReaderWriters.getBroadcastStateReaderForVersion(this.getReadVersion(), this.userCodeClassLoader).readBroadcastStateMetaInfo(in));
            }
        } else {
            this.broadcastStateMetaInfoSnapshots = new ArrayList();
        }
    }

    public List<RegisteredOperatorBackendStateMetaInfo.Snapshot<?>> getOperatorStateMetaInfoSnapshots() {
        return this.operatorStateMetaInfoSnapshots;
    }

    public List<RegisteredBroadcastBackendStateMetaInfo.Snapshot<?, ?>> getBroadcastStateMetaInfoSnapshots() {
        return this.broadcastStateMetaInfoSnapshots;
    }
}

