/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.SortedMapSerializer;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.runtime.state.InternalStateType;
import org.apache.flink.runtime.state.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.keyed.KeyedStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateDescriptor;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StateMigrationException;

public class RegisteredStateMetaInfo {
    private final InternalStateType internalStateType;
    private final String name;
    private final TypeSerializer keySerializer;
    private final TypeSerializer valueSerializer;
    private final TypeSerializer namespaceSerializer;

    private RegisteredStateMetaInfo(InternalStateType internalStateType, String name, TypeSerializer keySerializer, TypeSerializer valueSerializer, TypeSerializer namespaceSerializer) {
        this.internalStateType = (InternalStateType)((Object)Preconditions.checkNotNull((Object)((Object)internalStateType)));
        Preconditions.checkState((!internalStateType.isKeyedState() ? 1 : 0) != 0, (Object)"Expected subKeyed state.");
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull((Object)keySerializer);
        this.valueSerializer = (TypeSerializer)Preconditions.checkNotNull((Object)valueSerializer);
        this.checkValueSerializerType(internalStateType, valueSerializer);
        this.namespaceSerializer = (TypeSerializer)Preconditions.checkNotNull((Object)namespaceSerializer);
    }

    private RegisteredStateMetaInfo(InternalStateType internalStateType, String name, TypeSerializer keySerializer, TypeSerializer valueSerializer) {
        this.internalStateType = (InternalStateType)((Object)Preconditions.checkNotNull((Object)((Object)internalStateType)));
        Preconditions.checkState((boolean)internalStateType.isKeyedState(), (Object)"Expected keyed state.");
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull((Object)keySerializer);
        this.valueSerializer = (TypeSerializer)Preconditions.checkNotNull((Object)valueSerializer);
        this.checkValueSerializerType(internalStateType, valueSerializer);
        this.namespaceSerializer = VoidNamespaceSerializer.INSTANCE;
    }

    private void checkValueSerializerType(InternalStateType internalStateType, TypeSerializer valueSerializer) {
        switch (internalStateType) {
            case KEYED_LIST: 
            case SUBKEYED_LIST: {
                Preconditions.checkState((boolean)(valueSerializer instanceof ListSerializer), (Object)("Expected ListSerializer when creating " + (Object)((Object)internalStateType) + " state type."));
                break;
            }
            case KEYED_MAP: 
            case SUBKEYED_MAP: {
                Preconditions.checkState((boolean)(valueSerializer instanceof MapSerializer), (Object)("Expected MapSerializer when creating " + (Object)((Object)internalStateType) + " state type."));
                break;
            }
            case KEYED_SORTEDMAP: 
            case SUBKEYED_SORTEDMAP: {
                Preconditions.checkState((boolean)(valueSerializer instanceof SortedMapSerializer), (Object)("Expected SortedMapSerializer when creating " + (Object)((Object)internalStateType) + " state type."));
                break;
            }
        }
    }

    public StateMetaInfoSnapshot snapshot() {
        return new StateMetaInfoSnapshot(this.internalStateType, this.name, this.keySerializer.duplicate(), this.valueSerializer.duplicate(), this.namespaceSerializer.duplicate(), this.keySerializer.snapshotConfiguration(), this.valueSerializer.snapshotConfiguration(), this.namespaceSerializer.snapshotConfiguration());
    }

    public InternalStateType getStateType() {
        return this.internalStateType;
    }

    public String getName() {
        return this.name;
    }

    public TypeSerializer getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer getValueSerializer() {
        return this.valueSerializer;
    }

    public TypeSerializer getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public static RegisteredStateMetaInfo createKeyedStateMetaInfo(InternalStateType stateType, String name, TypeSerializer keySerializer, TypeSerializer valueSerializer) {
        return new RegisteredStateMetaInfo(stateType, name, keySerializer, valueSerializer);
    }

    public static RegisteredStateMetaInfo createSubKeyedStateMetaInfo(InternalStateType stateType, String name, TypeSerializer keySerializer, TypeSerializer valueSerializer, TypeSerializer namespaceSerializer) {
        return new RegisteredStateMetaInfo(stateType, name, keySerializer, valueSerializer, namespaceSerializer);
    }

    public static RegisteredStateMetaInfo createKeyedStateMetaInfo(StateMetaInfoSnapshot stateMetaInfoSnapshot) {
        return new RegisteredStateMetaInfo(stateMetaInfoSnapshot.getStateType(), stateMetaInfoSnapshot.getName(), stateMetaInfoSnapshot.getKeySerializer(), stateMetaInfoSnapshot.getValueSerializer());
    }

    public static RegisteredStateMetaInfo createSubKeyedStateMetaInfo(StateMetaInfoSnapshot stateMetaInfoSnapshot) {
        return new RegisteredStateMetaInfo(stateMetaInfoSnapshot.getStateType(), stateMetaInfoSnapshot.getName(), stateMetaInfoSnapshot.getKeySerializer(), stateMetaInfoSnapshot.getValueSerializer(), stateMetaInfoSnapshot.getNamespaceSerializer());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getStateType().hashCode();
        result = 31 * result + this.getStateType().hashCode();
        result = 31 * result + this.getStateType().hashCode();
        result = 31 * result + this.getKeySerializer().hashCode();
        result = 31 * result + this.getValueSerializer().hashCode();
        result = 31 * result + this.getNamespaceSerializer().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredStateMetaInfo that = (RegisteredStateMetaInfo)o;
        return this.getName().equals(that.getName()) && this.getStateType().equals((Object)that.getStateType()) && this.getStateType().equals((Object)that.getStateType()) && this.getKeySerializer().equals((Object)that.getKeySerializer()) && this.getValueSerializer().equals((Object)that.getValueSerializer()) && Objects.equals(this.getNamespaceSerializer(), that.getNamespaceSerializer());
    }

    public static RegisteredStateMetaInfo resolveStateCompatibility(StateMetaInfoSnapshot restoreStateMetaInfoSnapshot, SubKeyedStateDescriptor newSubKeyedStateDescriptor) throws StateMigrationException {
        Preconditions.checkState((boolean)Objects.equals(newSubKeyedStateDescriptor.getName(), restoreStateMetaInfoSnapshot.getName()), (Object)("Incompatible state names. Was [" + restoreStateMetaInfoSnapshot.getName() + "], registered with [" + newSubKeyedStateDescriptor.getName() + "]."));
        TypeSerializer newKeySerializer = newSubKeyedStateDescriptor.getKeySerializer();
        TypeSerializer newValueSerializer = newSubKeyedStateDescriptor.getValueSerializer();
        TypeSerializer newNamespaceSerializer = newSubKeyedStateDescriptor.getNamespaceSerializer();
        RegisteredStateMetaInfo.checkRequireMigration(Arrays.asList(Tuple4.of((Object)restoreStateMetaInfoSnapshot.getKeySerializer(), UnloadableDummyTypeSerializer.class, (Object)restoreStateMetaInfoSnapshot.getKeySerializerConfigSnapshot(), newKeySerializer), Tuple4.of((Object)restoreStateMetaInfoSnapshot.getValueSerializer(), UnloadableDummyTypeSerializer.class, (Object)restoreStateMetaInfoSnapshot.getValueSerializerConfigSnapshot(), newValueSerializer), Tuple4.of((Object)restoreStateMetaInfoSnapshot.getNamespaceSerializer(), null, (Object)restoreStateMetaInfoSnapshot.getNamespaceSerializerConfigSnapshot(), newNamespaceSerializer)));
        return new RegisteredStateMetaInfo(newSubKeyedStateDescriptor.getStateType(), newSubKeyedStateDescriptor.getName(), newKeySerializer, newValueSerializer, newNamespaceSerializer);
    }

    public static RegisteredStateMetaInfo resolveStateCompatibility(StateMetaInfoSnapshot restoreStateMetaInfoSnapshot, KeyedStateDescriptor newKeyedStateDescriptor) throws StateMigrationException {
        if (!VoidNamespaceSerializer.INSTANCE.equals(restoreStateMetaInfoSnapshot.getNamespaceSerializer())) {
            throw new IllegalStateException("Expected Keyed state's meta info snapshot.");
        }
        Preconditions.checkState((boolean)Objects.equals(newKeyedStateDescriptor.getName(), restoreStateMetaInfoSnapshot.getName()), (Object)("Incompatible state names. Was [" + restoreStateMetaInfoSnapshot.getName() + "], registered with [" + newKeyedStateDescriptor.getName() + "]."));
        TypeSerializer newKeySerializer = newKeyedStateDescriptor.getKeySerializer();
        TypeSerializer newValueSerializer = newKeyedStateDescriptor.getValueSerializer();
        RegisteredStateMetaInfo.checkRequireMigration(Arrays.asList(Tuple4.of((Object)restoreStateMetaInfoSnapshot.getKeySerializer(), UnloadableDummyTypeSerializer.class, (Object)restoreStateMetaInfoSnapshot.getKeySerializerConfigSnapshot(), newKeySerializer), Tuple4.of((Object)restoreStateMetaInfoSnapshot.getValueSerializer(), UnloadableDummyTypeSerializer.class, (Object)restoreStateMetaInfoSnapshot.getValueSerializerConfigSnapshot(), newValueSerializer)));
        return new RegisteredStateMetaInfo(newKeyedStateDescriptor.getStateType(), newKeyedStateDescriptor.getName(), newKeySerializer, newValueSerializer);
    }

    private static void checkRequireMigration(Collection<Tuple4<TypeSerializer, Class<?>, TypeSerializerConfigSnapshot, TypeSerializer>> serializersToCheck) throws StateMigrationException {
        for (Tuple4<TypeSerializer, Class<?>, TypeSerializerConfigSnapshot, TypeSerializer> tupleInfo : serializersToCheck) {
            TypeSerializerConfigSnapshot precedingSerializerConfigSnapshot = (TypeSerializerConfigSnapshot)tupleInfo.f2;
            TypeSerializer newSerializer = (TypeSerializer)tupleInfo.f3;
            CompatibilityResult compatibilityResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)((TypeSerializer)tupleInfo.f0), (Class)((Class)tupleInfo.f1), (TypeSerializerConfigSnapshot)precedingSerializerConfigSnapshot, (TypeSerializer)newSerializer);
            if (!compatibilityResult.isRequiresMigration()) continue;
            throw new StateMigrationException("State migration isn't supported, yet. PrecedingSerializerConfigSnapshot: " + precedingSerializerConfigSnapshot + " needs migration with new serializer: " + newSerializer);
        }
    }
}

