/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateBackendFactory;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.runtime.state.filesystem.FsStateBackendFactory;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackendFactory;
import org.apache.flink.util.DynamicCodeLoadingException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class StateBackendLoader {
    public static final String MEMORY_STATE_BACKEND_NAME = "jobmanager";
    public static final String FS_STATE_BACKEND_NAME = "filesystem";
    public static final String ROCKSDB_STATE_BACKEND_NAME = "rocksdb";

    public static StateBackend loadStateBackendFromConfig(Configuration config, ClassLoader classLoader, @Nullable Logger logger) throws IllegalConfigurationException, DynamicCodeLoadingException, IOException {
        StateBackendFactory factory;
        Preconditions.checkNotNull((Object)config, (String)"config");
        Preconditions.checkNotNull((Object)classLoader, (String)"classLoader");
        String backendName = config.getString(CheckpointingOptions.STATE_BACKEND);
        if (backendName == null) {
            return null;
        }
        String factoryClassName = backendName;
        switch (backendName.toLowerCase()) {
            case "jobmanager": {
                MemoryStateBackend memBackend = new MemoryStateBackendFactory().createFromConfig(config);
                if (logger != null) {
                    Path memExternalized = memBackend.getCheckpointPath();
                    String extern = memExternalized == null ? "" : " (externalized to " + memExternalized + ')';
                    logger.info("State backend is set to heap memory (checkpoint to JobManager) {}", (Object)extern);
                }
                return memBackend;
            }
            case "filesystem": {
                FsStateBackend fsBackend = new FsStateBackendFactory().createFromConfig(config);
                if (logger != null) {
                    logger.info("State backend is set to heap memory (checkpoints to filesystem \"{}\")", (Object)fsBackend.getCheckpointPath());
                }
                return fsBackend;
            }
            case "rocksdb": {
                factoryClassName = "org.apache.flink.contrib.streaming.state.RocksDBStateBackendFactory";
            }
        }
        if (logger != null) {
            logger.info("Loading state backend via factory {}", (Object)factoryClassName);
        }
        try {
            Class<StateBackendFactory> clazz = Class.forName(factoryClassName, false, classLoader).asSubclass(StateBackendFactory.class);
            factory = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new DynamicCodeLoadingException("Cannot find configured state backend factory class: " + backendName, (Throwable)e);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException e) {
            throw new DynamicCodeLoadingException("The class configured under '" + CheckpointingOptions.STATE_BACKEND.key() + "' is not a valid state backend factory (" + backendName + ')', (Throwable)e);
        }
        return factory.createFromConfig(config);
    }

    public static StateBackend fromApplicationOrConfigOrDefault(@Nullable StateBackend fromApplication, Configuration config, ClassLoader classLoader, @Nullable Logger logger) throws IllegalConfigurationException, DynamicCodeLoadingException, IOException {
        StateBackend backend;
        Preconditions.checkNotNull((Object)config, (String)"config");
        Preconditions.checkNotNull((Object)classLoader, (String)"classLoader");
        if (fromApplication != null) {
            if (logger != null) {
                logger.info("Using application-defined state backend: {}", (Object)fromApplication);
            }
            if (fromApplication instanceof ConfigurableStateBackend) {
                if (logger != null) {
                    logger.info("Configuring application-defined state backend with job/cluster config");
                }
                backend = ((ConfigurableStateBackend)((Object)fromApplication)).configure(config);
            } else {
                backend = fromApplication;
            }
        } else {
            StateBackend fromConfig = StateBackendLoader.loadStateBackendFromConfig(config, classLoader, logger);
            if (fromConfig != null) {
                backend = fromConfig;
            } else {
                backend = new MemoryStateBackendFactory().createFromConfig(config);
                if (logger != null) {
                    logger.info("No state backend has been configured, using default (Memory / JobManager) {}", (Object)backend);
                }
            }
        }
        return backend;
    }

    private StateBackendLoader() {
    }
}

