/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.DefaultPair;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public class StateSerializerUtil {
    private static final byte KEY_PREFIX_BYTE = 15;
    public static final byte KEY_END_BYTE = 127;
    private static final int KEY_PREFIX_BYTE_LENGTH = 1;
    public static final int GROUP_WRITE_BYTES = 2;
    public static final byte DELIMITER = 44;

    public static <K> byte[] getSerializedKeyForKeyedValueState(ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, K key, TypeSerializer<K> keySerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.serializeSingleKey(outputView, key, keySerializer, group, stateNameByte);
        return outputStream.toByteArray();
    }

    public static <K> K getDeserializedKeyForKeyedValueState(byte[] serializedKey, TypeSerializer<K> keySerializer, int serializedStateNameLength) throws IOException {
        ByteArrayInputStreamWithPos inputStream = new ByteArrayInputStreamWithPos(serializedKey);
        DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)inputStream);
        return StateSerializerUtil.getDeserializedSingleKey(inputView, keySerializer, serializedStateNameLength);
    }

    public static <K> byte[] getSerializedKeyForKeyedListState(ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, K key, TypeSerializer<K> keySerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.serializeSingleKey(outputView, key, keySerializer, group, stateNameByte);
        return outputStream.toByteArray();
    }

    public static <K> K getDeserializedKeyForKeyedListState(byte[] serializedKey, TypeSerializer<K> keySerializer, int serializedStateNameLength) throws IOException {
        ByteArrayInputStreamWithPos inputStream = new ByteArrayInputStreamWithPos(serializedKey);
        DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)inputStream);
        return StateSerializerUtil.getDeserializedSingleKey(inputView, keySerializer, serializedStateNameLength);
    }

    public static <K> byte[] getSerializedPrefixKeyForKeyedMapState(ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, K key, TypeSerializer<K> keySerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.serializeSingleKey(outputView, key, keySerializer, group, stateNameByte);
        return outputStream.toByteArray();
    }

    public static <K, MK> byte[] getSerializedPrefixKeyEndForKeyedMapState(ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, K key, TypeSerializer<K> keySerializer, MK mapKey, TypeSerializer<MK> mapKeySerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.getSerializedKeyForKeyedValueState(outputStream, outputView, key, keySerializer, group, stateNameByte);
        if (mapKey != null) {
            outputView.write(15);
            mapKeySerializer.serialize(mapKey, outputView);
        }
        outputView.write(127);
        return outputStream.toByteArray();
    }

    public static <K, N, MK> byte[] getSerializedPrefixKeyEndForSubKeyedMapState(ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, K key, TypeSerializer<K> keySerializer, N namespace, TypeSerializer<N> namespaceSerializer, MK mapKey, TypeSerializer<MK> mapKeySerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.serializeSingleKey(outputView, key, keySerializer, group, stateNameByte);
        StateSerializerUtil.serializeItemWithKeyPrefix(outputView, namespace, namespaceSerializer);
        if (mapKey != null) {
            StateSerializerUtil.serializeItemWithKeyPrefix(outputView, mapKey, mapKeySerializer);
        }
        outputView.write(127);
        return outputStream.toByteArray();
    }

    public static <K, MK> byte[] getSerializedKeyForKeyedMapState(ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, K key, TypeSerializer<K> keySerializer, MK mapKey, TypeSerializer<MK> mapKeySerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.serializeDoubleKey(outputView, key, keySerializer, mapKey, mapKeySerializer, group, stateNameByte);
        return outputStream.toByteArray();
    }

    public static <K> K getDeserializedKeyForKeyedMapState(byte[] serializedBytes, TypeSerializer<K> keySerializer, int serializedStateNameLength) throws IOException {
        ByteArrayInputStreamWithPos inputStream = new ByteArrayInputStreamWithPos(serializedBytes);
        DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)inputStream);
        return StateSerializerUtil.getDeserializedSingleKey(inputView, keySerializer, serializedStateNameLength);
    }

    public static <K, MK> MK getDeserializedMapKeyForKeyedMapState(byte[] serializedBytes, TypeSerializer<K> keySerializer, TypeSerializer<MK> mapKeySerializer, int serializedStateNameLength) throws IOException {
        ByteArrayInputStreamWithPos inputStream = new ByteArrayInputStreamWithPos(serializedBytes);
        DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)inputStream);
        return StateSerializerUtil.getDeserializedSecondKey(inputView, keySerializer, mapKeySerializer, serializedStateNameLength);
    }

    public static <K, N, MK> MK getDeserializedMapKeyForSubKeyedMapState(byte[] serializedBytes, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<MK> mapKeySerializer, int serializedStateNameLength) throws IOException {
        ByteArrayInputStreamWithPos inputStream = new ByteArrayInputStreamWithPos(serializedBytes);
        DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)inputStream);
        StateSerializerUtil.getDeserializedSecondKey(inputView, keySerializer, namespaceSerializer, serializedStateNameLength);
        inputView.skipBytesToRead(1);
        return (MK)mapKeySerializer.deserialize((DataInputView)inputView);
    }

    public static <K, N> N getDeserializedNamespcae(byte[] serializedBytes, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, int serializedStateNameLength) throws IOException {
        ByteArrayInputStreamWithPos inputStream = new ByteArrayInputStreamWithPos(serializedBytes);
        DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)inputStream);
        return StateSerializerUtil.getDeserializedSecondKey(inputView, keySerializer, namespaceSerializer, serializedStateNameLength);
    }

    public static <K, N> Pair<K, N> getDeserializedKeyAndNamespace(byte[] serializedBytes, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, int serializedStateNameLenght) throws IOException {
        ByteArrayInputStreamWithPos inputStream = new ByteArrayInputStreamWithPos(serializedBytes);
        DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)inputStream);
        K key = StateSerializerUtil.getDeserializedSingleKey(inputView, keySerializer, serializedStateNameLenght);
        inputView.skipBytesToRead(1);
        Object namespace = namespaceSerializer.deserialize((DataInputView)inputView);
        return new DefaultPair(key, namespace);
    }

    public static <K, N> byte[] getSerializedKeyForSubKeyedValueState(ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, K key, TypeSerializer<K> keySerializer, N namespace, TypeSerializer<N> namespaceSerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.serializeSingleKeyWithNamespace(outputView, key, keySerializer, namespace, namespaceSerializer, group, stateNameByte);
        return outputStream.toByteArray();
    }

    public static <K, N> byte[] getSerializedKeyForSubKeyedListState(ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, K key, TypeSerializer<K> keySerializer, N namespace, TypeSerializer<N> namespaceSerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.serializeSingleKeyWithNamespace(outputView, key, keySerializer, namespace, namespaceSerializer, group, stateNameByte);
        return outputStream.toByteArray();
    }

    public static <K, MK, N> byte[] getSerializedKeyForSubKeyedMapState(ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, K key, TypeSerializer<K> keySerializer, N namespace, TypeSerializer<N> namespaceSerializer, MK mapKey, TypeSerializer<MK> mapKeySerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.serializeDoubleKeyWithNamespace(outputView, key, keySerializer, mapKey, mapKeySerializer, namespace, namespaceSerializer, group, stateNameByte);
        return outputStream.toByteArray();
    }

    public static <K, N> byte[] getSerializedPrefixKeyForSubKeyedState(ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, K key, TypeSerializer<K> keySerializer, N namespace, TypeSerializer<N> namespaceSerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.serializeSingleKey(outputView, key, keySerializer, group, stateNameByte);
        if (namespace != null) {
            StateSerializerUtil.serializeItemWithKeyPrefix(outputView, namespace, namespaceSerializer);
        }
        return outputStream.toByteArray();
    }

    public static <V> byte[] getSerializeSingleValue(ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, V value, TypeSerializer<V> valueSerializer) throws IOException {
        valueSerializer.serialize(value, outputView);
        return outputStream.toByteArray();
    }

    public static <V> V getDeserializeSingleValue(byte[] serializedValue, TypeSerializer<V> valueSerializer) throws IOException {
        ByteArrayInputStreamWithPos inputStream = new ByteArrayInputStreamWithPos(serializedValue);
        DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)inputStream);
        return (V)valueSerializer.deserialize((DataInputView)inputView);
    }

    public static <E> List<E> getDeserializeList(byte[] valueBytes, TypeSerializer<E> elementSerializer) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(valueBytes);
        DataInputViewStreamWrapper in = new DataInputViewStreamWrapper((InputStream)bais);
        ArrayList<Object> result = new ArrayList<Object>();
        while (in.available() > 0) {
            result.add(elementSerializer.deserialize((DataInputView)in));
            if (in.available() <= 0) continue;
            in.readByte();
        }
        return result;
    }

    public static <E> void getPreMergedList(DataOutputView outputView, Collection<? extends E> values, TypeSerializer<E> elementSerializer) throws IOException {
        boolean first = true;
        for (E value : values) {
            Preconditions.checkNotNull(value, (String)"You cannot add null to a ListState.");
            if (first) {
                first = false;
            } else {
                outputView.write(44);
            }
            elementSerializer.serialize(value, outputView);
        }
    }

    private static <F, S> S getDeserializedSecondKey(DataInputViewStreamWrapper inputView, TypeSerializer<F> firstSerializer, TypeSerializer<S> secondeSerializer, int serializedStateNameLength) throws IOException {
        StateSerializerUtil.getDeserializedSingleKey(inputView, firstSerializer, serializedStateNameLength);
        inputView.skipBytesToRead(1);
        return (S)secondeSerializer.deserialize((DataInputView)inputView);
    }

    private static <K> void serializeSingleKey(DataOutputView outputView, K key, TypeSerializer<K> keySerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.writeGroup(outputView, group);
        if (stateNameByte != null) {
            outputView.write(stateNameByte);
        }
        StateSerializerUtil.serializeItemWithKeyPrefix(outputView, key, keySerializer);
    }

    private static <K, MK> void serializeDoubleKey(DataOutputView outputView, K key, TypeSerializer<K> keySerializer, MK mapKey, TypeSerializer<MK> mapKeySerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.serializeSingleKey(outputView, key, keySerializer, group, stateNameByte);
        StateSerializerUtil.serializeItemWithKeyPrefix(outputView, mapKey, mapKeySerializer);
    }

    private static <K, N> void serializeSingleKeyWithNamespace(DataOutputView outputView, K key, TypeSerializer<K> keySerializer, N namespace, TypeSerializer<N> namespaceSerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.serializeSingleKey(outputView, key, keySerializer, group, stateNameByte);
        StateSerializerUtil.serializeItemWithKeyPrefix(outputView, namespace, namespaceSerializer);
    }

    private static <K, N, MK> void serializeDoubleKeyWithNamespace(DataOutputView outputView, K key, TypeSerializer<K> keySerializer, MK mapKey, TypeSerializer<MK> mapKeySerializer, N namespace, TypeSerializer<N> namespaceSerializer, int group, byte[] stateNameByte) throws IOException {
        StateSerializerUtil.serializeSingleKeyWithNamespace(outputView, key, keySerializer, namespace, namespaceSerializer, group, stateNameByte);
        StateSerializerUtil.serializeItemWithKeyPrefix(outputView, mapKey, mapKeySerializer);
    }

    private static <K> K getDeserializedSingleKey(DataInputViewStreamWrapper inputView, TypeSerializer<K> keySerializer, int serializedStateNameLength) throws IOException {
        inputView.skipBytesToRead(2 + serializedStateNameLength + 1);
        return (K)keySerializer.deserialize((DataInputView)inputView);
    }

    public static <K> void serializeItemWithKeyPrefix(DataOutputView outputView, K item, TypeSerializer<K> itemSerializer) throws IOException {
        outputView.write(15);
        itemSerializer.serialize(item, outputView);
    }

    public static void serializeGroupPrefix(ByteArrayOutputStreamWithPos outputStream, int group, @Nullable byte[] stateNameBytes) throws IOException {
        StateSerializerUtil.writeGroup(outputStream, group);
        if (stateNameBytes != null) {
            outputStream.write(stateNameBytes);
        }
    }

    public static void writeGroup(ByteArrayOutputStreamWithPos outputStream, int group) {
        outputStream.write(group >>> 8 & 0xFF);
        outputStream.write(group & 0xFF);
    }

    public static void writeGroup(DataOutputView outputView, int group) throws IOException {
        outputView.write(group >>> 8 & 0xFF);
        outputView.write(group & 0xFF);
    }

    public static int getGroupFromSerializedKey(byte[] serializedBytes) throws IOException {
        ByteArrayInputStreamWithPos inputStream = new ByteArrayInputStreamWithPos(serializedBytes);
        DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)inputStream);
        return (inputView.readByte() << 8) + inputView.readByte();
    }
}

