/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import java.util.Collection;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.context.ContextKeyedState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.util.Preconditions;

public class ContextReducingState<K, T>
implements ContextKeyedState<K, T>,
ReducingState<T>,
InternalReducingState<K, VoidNamespace, T> {
    private final KeyContextImpl<K> keyContext;
    private final KeyedValueState<Object, T> keyedState;
    private final ReduceTransformation transformation;

    public ContextReducingState(KeyContextImpl<K> keyContext, KeyedValueState<Object, T> keyedState, ReduceFunction<T> reduceFunction) {
        Preconditions.checkNotNull(keyContext);
        Preconditions.checkNotNull(keyedState);
        Preconditions.checkNotNull(reduceFunction);
        this.keyContext = keyContext;
        this.keyedState = keyedState;
        this.transformation = new ReduceTransformation(reduceFunction);
    }

    public T get() {
        return (T)this.keyedState.get(this.keyContext.getCurrentKey());
    }

    public void add(T value) {
        this.keyedState.transform(this.keyContext.getCurrentKey(), value, this.transformation);
    }

    public void clear() {
        this.keyedState.remove(this.keyContext.getCurrentKey());
    }

    @Override
    public void mergeNamespaces(VoidNamespace target, Collection<VoidNamespace> sources) throws Exception {
        throw new UnsupportedOperationException("mergeNamespaces should not be called within keyed state.");
    }

    @Override
    public KeyedState getKeyedState() {
        return this.keyedState;
    }

    @Override
    public TypeSerializer getKeySerializer() {
        return this.keyContext.getKeySerializer();
    }

    @Override
    public TypeSerializer<T> getValueSerializer() {
        return this.keyedState.getDescriptor().getValueSerializer();
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer safeKeySerializer, TypeSerializer safeNamespaceSerializer, TypeSerializer safeValueSerializer) throws Exception {
        return this.keyedState.getSerializedValue(serializedKeyAndNamespace, (TypeSerializer<Object>)safeKeySerializer, safeValueSerializer);
    }

    private class ReduceTransformation
    implements StateTransformationFunction<T, T> {
        private final ReduceFunction<T> reduceFunction;

        public ReduceTransformation(ReduceFunction<T> reduceFunction) {
            this.reduceFunction = (ReduceFunction)Preconditions.checkNotNull(reduceFunction);
        }

        @Override
        public T apply(T previousState, T value) throws Exception {
            return previousState == null ? value : this.reduceFunction.reduce(previousState, value);
        }
    }
}

