/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.AggregatingState;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.SortedMapState;
import org.apache.flink.api.common.state.SortedMapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateBinder;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractInternalStateBackend;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.context.ContextAggregatingState;
import org.apache.flink.runtime.state.context.ContextFoldingState;
import org.apache.flink.runtime.state.context.ContextListState;
import org.apache.flink.runtime.state.context.ContextMapState;
import org.apache.flink.runtime.state.context.ContextReducingState;
import org.apache.flink.runtime.state.context.ContextSortedMapState;
import org.apache.flink.runtime.state.context.ContextSubKeyedAggregatingState;
import org.apache.flink.runtime.state.context.ContextSubKeyedFoldingState;
import org.apache.flink.runtime.state.context.ContextSubKeyedListState;
import org.apache.flink.runtime.state.context.ContextSubKeyedMapState;
import org.apache.flink.runtime.state.context.ContextSubKeyedReducingState;
import org.apache.flink.runtime.state.context.ContextSubKeyedValueState;
import org.apache.flink.runtime.state.context.ContextValueState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.keyed.KeyedListState;
import org.apache.flink.runtime.state.keyed.KeyedListStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.runtime.state.keyed.KeyedMapStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapState;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.runtime.state.keyed.KeyedValueStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueStateDescriptor;
import org.apache.flink.util.Preconditions;

public class ContextStateHelper
implements StateBinder {
    private final Map<String, State> states;
    private final KeyContextImpl keyContext;
    private final ExecutionConfig executionConfig;
    private final AbstractInternalStateBackend internalStateBackend;
    private String lastStateName;
    private InternalKvState lastState;
    private final TaskKvStateRegistry kvStateRegistry;

    public ContextStateHelper(KeyContextImpl keyContext, ExecutionConfig executionConfig, AbstractInternalStateBackend internalStateBackend) {
        this.keyContext = (KeyContextImpl)Preconditions.checkNotNull((Object)keyContext);
        this.executionConfig = (ExecutionConfig)Preconditions.checkNotNull((Object)executionConfig);
        this.internalStateBackend = (AbstractInternalStateBackend)Preconditions.checkNotNull((Object)internalStateBackend);
        this.kvStateRegistry = internalStateBackend.getKvStateRegistry();
        this.states = new HashMap<String, State>();
    }

    public String getLastStateName() {
        return this.lastStateName;
    }

    public InternalKvState getLastState() {
        return this.lastState;
    }

    public <T> ValueState<T> createValueState(ValueStateDescriptor<T> stateDesc) throws Exception {
        Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
        String stateName = stateDesc.getName();
        ContextValueState state = this.states.get(stateName);
        if (state == null) {
            stateDesc.initializeSerializerUnlessSet(this.executionConfig);
            KeyedValueStateDescriptor keyedStateDescriptor = new KeyedValueStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), stateDesc.getSerializer());
            KeyedValueState keyedState = (KeyedValueState)this.internalStateBackend.getKeyedState(keyedStateDescriptor);
            state = new ContextValueState(this.keyContext, keyedState, stateDesc);
            this.registerAsQueryableState((StateDescriptor)stateDesc, state);
            this.states.put(stateName, state);
        }
        return state;
    }

    public <N, T> ValueState<T> createValueState(TypeSerializer<N> namespaceSerializer, ValueStateDescriptor<T> stateDesc) throws Exception {
        ContextSubKeyedValueState state;
        Preconditions.checkNotNull(namespaceSerializer, (String)"namespaceSerializer cannot be null.");
        if (VoidNamespaceSerializer.INSTANCE.equals(namespaceSerializer)) {
            state = this.createValueState(stateDesc);
        } else {
            Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
            String stateName = stateDesc.getName();
            state = this.states.get(stateName);
            if (state == null) {
                stateDesc.initializeSerializerUnlessSet(this.executionConfig);
                SubKeyedValueStateDescriptor subKeyedValueStateDescriptor = new SubKeyedValueStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), namespaceSerializer, stateDesc.getSerializer());
                SubKeyedValueState subKeyedValueState = (SubKeyedValueState)this.internalStateBackend.getSubKeyedState(subKeyedValueStateDescriptor);
                state = new ContextSubKeyedValueState(this.keyContext, subKeyedValueState, stateDesc.getDefaultValue());
                this.registerAsQueryableState((StateDescriptor)stateDesc, state);
                this.states.put(stateName, state);
            }
        }
        return state;
    }

    public <T> ListState<T> createListState(ListStateDescriptor<T> stateDesc) throws Exception {
        Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
        String stateName = stateDesc.getName();
        ContextListState state = this.states.get(stateName);
        if (state == null) {
            stateDesc.initializeSerializerUnlessSet(this.executionConfig);
            KeyedListStateDescriptor keyedStateDescriptor = new KeyedListStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), stateDesc.getElementSerializer());
            KeyedListState keyedState = (KeyedListState)this.internalStateBackend.getKeyedState(keyedStateDescriptor);
            state = new ContextListState(this.keyContext, keyedState);
            this.registerAsQueryableState((StateDescriptor)stateDesc, state);
            this.states.put(stateName, state);
        }
        return state;
    }

    public <N, T> ListState<T> createListState(TypeSerializer<N> namespaceSerializer, ListStateDescriptor<T> stateDesc) throws Exception {
        ContextSubKeyedListState state;
        Preconditions.checkNotNull(namespaceSerializer, (String)"namespaceSerializer cannot be null.");
        if (VoidNamespaceSerializer.INSTANCE.equals(namespaceSerializer)) {
            state = this.createListState(stateDesc);
        } else {
            Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
            String stateName = stateDesc.getName();
            state = this.states.get(stateName);
            if (state == null) {
                stateDesc.initializeSerializerUnlessSet(this.executionConfig);
                SubKeyedListStateDescriptor subKeyedListStateDescriptor = new SubKeyedListStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), namespaceSerializer, stateDesc.getElementSerializer());
                SubKeyedListState subKeyedListState = (SubKeyedListState)this.internalStateBackend.getSubKeyedState(subKeyedListStateDescriptor);
                state = new ContextSubKeyedListState(this.keyContext, subKeyedListState);
                this.registerAsQueryableState((StateDescriptor)stateDesc, state);
                this.states.put(stateName, state);
            }
        }
        return state;
    }

    public <T> ReducingState<T> createReducingState(ReducingStateDescriptor<T> stateDesc) throws Exception {
        Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
        String stateName = stateDesc.getName();
        ContextReducingState state = this.states.get(stateName);
        if (state == null) {
            stateDesc.initializeSerializerUnlessSet(this.executionConfig);
            KeyedValueStateDescriptor keyedStateDescriptor = new KeyedValueStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), stateDesc.getSerializer());
            KeyedValueState keyedState = (KeyedValueState)this.internalStateBackend.getKeyedState(keyedStateDescriptor);
            state = new ContextReducingState(this.keyContext, keyedState, stateDesc.getReduceFunction());
            this.registerAsQueryableState((StateDescriptor)stateDesc, state);
            this.states.put(stateName, state);
        }
        return state;
    }

    public <N, T> ReducingState<T> createReducingState(TypeSerializer<N> namespaceSerializer, ReducingStateDescriptor<T> stateDesc) throws Exception {
        ContextSubKeyedReducingState state;
        Preconditions.checkNotNull(namespaceSerializer, (String)"namespaceSerializer cannot be null.");
        if (VoidNamespaceSerializer.INSTANCE.equals(namespaceSerializer)) {
            state = this.createReducingState(stateDesc);
        } else {
            Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
            String stateName = stateDesc.getName();
            state = this.states.get(stateName);
            if (state == null) {
                stateDesc.initializeSerializerUnlessSet(this.executionConfig);
                SubKeyedValueStateDescriptor subKeyedValueStateDescriptor = new SubKeyedValueStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), namespaceSerializer, stateDesc.getSerializer());
                SubKeyedValueState subKeyedValueState = (SubKeyedValueState)this.internalStateBackend.getSubKeyedState(subKeyedValueStateDescriptor);
                state = new ContextSubKeyedReducingState(this.keyContext, subKeyedValueState, stateDesc.getReduceFunction());
                this.registerAsQueryableState((StateDescriptor)stateDesc, state);
                this.states.put(stateName, state);
            }
        }
        return state;
    }

    public <IN, ACC, OUT> AggregatingState<IN, OUT> createAggregatingState(AggregatingStateDescriptor<IN, ACC, OUT> stateDesc) throws Exception {
        Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
        String stateName = stateDesc.getName();
        ContextAggregatingState state = this.states.get(stateName);
        if (state == null) {
            stateDesc.initializeSerializerUnlessSet(this.executionConfig);
            KeyedValueStateDescriptor keyedStateDescriptor = new KeyedValueStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), stateDesc.getSerializer());
            KeyedValueState keyedState = (KeyedValueState)this.internalStateBackend.getKeyedState(keyedStateDescriptor);
            state = new ContextAggregatingState(this.keyContext, keyedState, stateDesc.getAggregateFunction());
            this.registerAsQueryableState((StateDescriptor)stateDesc, state);
            this.states.put(stateName, state);
        }
        return state;
    }

    public <N, IN, ACC, OUT> AggregatingState<IN, OUT> createAggregatingState(TypeSerializer<N> namespaceSerializer, AggregatingStateDescriptor<IN, ACC, OUT> stateDesc) throws Exception {
        ContextSubKeyedAggregatingState state;
        Preconditions.checkNotNull(namespaceSerializer, (String)"namespaceSerializer cannot be null.");
        if (VoidNamespaceSerializer.INSTANCE.equals(namespaceSerializer)) {
            state = this.createAggregatingState(stateDesc);
        } else {
            Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
            String stateName = stateDesc.getName();
            state = this.states.get(stateName);
            if (state == null) {
                stateDesc.initializeSerializerUnlessSet(this.executionConfig);
                SubKeyedValueStateDescriptor subKeyedValueStateDescriptor = new SubKeyedValueStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), namespaceSerializer, stateDesc.getSerializer());
                SubKeyedValueState subKeyedValueState = (SubKeyedValueState)this.internalStateBackend.getSubKeyedState(subKeyedValueStateDescriptor);
                state = new ContextSubKeyedAggregatingState(this.keyContext, subKeyedValueState, stateDesc.getAggregateFunction());
                this.registerAsQueryableState((StateDescriptor)stateDesc, state);
                this.states.put(stateName, state);
            }
        }
        return state;
    }

    public <T, ACC> FoldingState<T, ACC> createFoldingState(FoldingStateDescriptor<T, ACC> stateDesc) throws Exception {
        Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
        String stateName = stateDesc.getName();
        ContextFoldingState state = this.states.get(stateName);
        if (state == null) {
            stateDesc.initializeSerializerUnlessSet(this.executionConfig);
            KeyedValueStateDescriptor keyedStateDescriptor = new KeyedValueStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), stateDesc.getSerializer());
            KeyedValueState keyedState = (KeyedValueState)this.internalStateBackend.getKeyedState(keyedStateDescriptor);
            state = new ContextFoldingState(this.keyContext, keyedState, stateDesc);
            this.registerAsQueryableState((StateDescriptor)stateDesc, state);
            this.states.put(stateName, state);
        }
        return state;
    }

    public <N, IN, ACC> FoldingState<IN, ACC> createFoldingState(TypeSerializer<N> namespaceSerializer, FoldingStateDescriptor<IN, ACC> stateDesc) throws Exception {
        ContextSubKeyedFoldingState state;
        Preconditions.checkNotNull(namespaceSerializer, (String)"namespaceSerializer cannot be null.");
        if (VoidNamespaceSerializer.INSTANCE.equals(namespaceSerializer)) {
            state = this.createFoldingState(stateDesc);
        } else {
            Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
            String stateName = stateDesc.getName();
            state = this.states.get(stateName);
            if (state == null) {
                stateDesc.initializeSerializerUnlessSet(this.executionConfig);
                SubKeyedValueStateDescriptor subKeyedValueStateDescriptor = new SubKeyedValueStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), namespaceSerializer, stateDesc.getSerializer());
                SubKeyedValueState subKeyedValueState = (SubKeyedValueState)this.internalStateBackend.getSubKeyedState(subKeyedValueStateDescriptor);
                state = new ContextSubKeyedFoldingState(this.keyContext, subKeyedValueState, stateDesc);
                this.registerAsQueryableState((StateDescriptor)stateDesc, state);
                this.states.put(stateName, state);
            }
        }
        return state;
    }

    public <MK, MV> MapState<MK, MV> createMapState(MapStateDescriptor<MK, MV> stateDesc) throws Exception {
        Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
        String stateName = stateDesc.getName();
        ContextMapState state = this.states.get(stateName);
        if (state == null) {
            stateDesc.initializeSerializerUnlessSet(this.executionConfig);
            KeyedMapStateDescriptor keyedStateDescriptor = new KeyedMapStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), stateDesc.getKeySerializer(), stateDesc.getValueSerializer());
            KeyedMapState keyedState = (KeyedMapState)this.internalStateBackend.getKeyedState(keyedStateDescriptor);
            state = new ContextMapState(this.keyContext, keyedState);
            this.registerAsQueryableState((StateDescriptor)stateDesc, state);
            this.states.put(stateName, state);
        }
        return state;
    }

    public <N, MK, MV> MapState<MK, MV> createMapState(TypeSerializer<N> namespaceSerializer, MapStateDescriptor<MK, MV> stateDesc) throws Exception {
        ContextSubKeyedMapState state;
        Preconditions.checkNotNull(namespaceSerializer, (String)"namespaceSerializer cannot be null.");
        if (VoidNamespaceSerializer.INSTANCE.equals(namespaceSerializer)) {
            state = this.createMapState(stateDesc);
        } else {
            Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
            String stateName = stateDesc.getName();
            state = this.states.get(stateName);
            if (state == null) {
                stateDesc.initializeSerializerUnlessSet(this.executionConfig);
                SubKeyedMapStateDescriptor subKeyedMapStateDescriptor = new SubKeyedMapStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), namespaceSerializer, stateDesc.getKeySerializer(), stateDesc.getValueSerializer());
                SubKeyedMapState subKeyedMapState = (SubKeyedMapState)this.internalStateBackend.getSubKeyedState(subKeyedMapStateDescriptor);
                state = new ContextSubKeyedMapState(this.keyContext, subKeyedMapState);
                this.registerAsQueryableState((StateDescriptor)stateDesc, state);
                this.states.put(stateName, state);
            }
        }
        return state;
    }

    public <MK, MV> SortedMapState<MK, MV> createSortedMapState(SortedMapStateDescriptor<MK, MV> stateDesc) throws Exception {
        Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
        String stateName = stateDesc.getName();
        ContextSortedMapState state = this.states.get(stateName);
        if (state == null) {
            stateDesc.initializeSerializerUnlessSet(this.executionConfig);
            KeyedSortedMapStateDescriptor keyedStateDescriptor = new KeyedSortedMapStateDescriptor(stateDesc.getName(), this.keyContext.getKeySerializer(), stateDesc.getSerializer());
            KeyedSortedMapState keyedState = (KeyedSortedMapState)this.internalStateBackend.getKeyedState(keyedStateDescriptor);
            state = new ContextSortedMapState(this.keyContext, keyedState);
            this.registerAsQueryableState((StateDescriptor)stateDesc, state);
            this.states.put(stateName, state);
        }
        return state;
    }

    public <N, MK, MV> SortedMapState<MK, MV> createSortedMapState(TypeSerializer<N> namespaceSerializer, SortedMapStateDescriptor<MK, MV> stateDesc) throws Exception {
        Preconditions.checkNotNull(namespaceSerializer, (String)"namespaceSerializer cannot be null.");
        Preconditions.checkNotNull(stateDesc, (String)"stateDesc cannot be null.");
        String stateName = stateDesc.getName();
        State state = this.states.get(stateName);
        if (state == null && VoidNamespaceSerializer.INSTANCE.equals(namespaceSerializer)) {
            return this.createSortedMapState(stateDesc);
        }
        throw new UnsupportedOperationException("Not supported to create sorted map state with namespace.");
    }

    public <N, S extends State> S getOrCreateKeyedState(TypeSerializer<N> namespaceSerializer, StateDescriptor<S, ?> stateDescriptor) throws Exception {
        Preconditions.checkNotNull(stateDescriptor);
        Preconditions.checkNotNull(namespaceSerializer, (String)"namespaceSerializer cannot be null.");
        String stateName = stateDescriptor.getName();
        if (this.lastStateName != null && this.lastStateName.equals(stateName)) {
            return (S)this.lastState;
        }
        ValueState state = null;
        switch (stateDescriptor.getType()) {
            case VALUE: {
                state = this.createValueState(namespaceSerializer, (ValueStateDescriptor)stateDescriptor);
                break;
            }
            case LIST: {
                state = this.createListState(namespaceSerializer, (ListStateDescriptor)stateDescriptor);
                break;
            }
            case MAP: {
                state = this.createMapState(namespaceSerializer, (MapStateDescriptor)stateDescriptor);
                break;
            }
            case FOLDING: {
                state = this.createFoldingState(namespaceSerializer, (FoldingStateDescriptor)stateDescriptor);
                break;
            }
            case REDUCING: {
                state = this.createReducingState(namespaceSerializer, (ReducingStateDescriptor)stateDescriptor);
                break;
            }
            case AGGREGATING: {
                state = this.createAggregatingState(namespaceSerializer, (AggregatingStateDescriptor)stateDescriptor);
                break;
            }
            case SORTEDMAP: {
                state = this.createSortedMapState(namespaceSerializer, (SortedMapStateDescriptor)stateDescriptor);
                break;
            }
            default: {
                throw new RuntimeException("Not a supported State: " + stateDescriptor.getType());
            }
        }
        this.lastStateName = stateName;
        this.lastState = (InternalKvState)state;
        return (S)state;
    }

    public <N, S extends State> S getPartitionedState(N namespace, TypeSerializer<N> namespaceSerializer, StateDescriptor<S, ?> stateDescriptor) throws Exception {
        Preconditions.checkNotNull(namespace, (String)"Namespace cannot be null.");
        String stateName = stateDescriptor.getName();
        if (this.lastStateName != null && this.lastStateName.equals(stateName)) {
            this.lastState.setCurrentNamespace(namespace);
            return (S)this.lastState;
        }
        State previous = this.states.get(stateName);
        if (previous != null) {
            this.lastState = (InternalKvState)previous;
            this.lastState.setCurrentNamespace(namespace);
            this.lastStateName = stateName;
            return (S)previous;
        }
        S state = this.getOrCreateKeyedState(namespaceSerializer, stateDescriptor);
        InternalKvState kvState = (InternalKvState)state;
        this.lastStateName = stateName;
        this.lastState = kvState;
        kvState.setCurrentNamespace(namespace);
        return state;
    }

    public KeyContextImpl getKeyContext() {
        return this.keyContext;
    }

    public AbstractInternalStateBackend getInternalStateBackend() {
        return this.internalStateBackend;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public void dispose() {
        if (this.kvStateRegistry != null) {
            this.kvStateRegistry.unregisterAll();
        }
        this.states.clear();
        this.lastState = null;
        this.lastStateName = null;
    }

    private void registerAsQueryableState(StateDescriptor stateDesc, State state) {
        if (stateDesc.isQueryable()) {
            Preconditions.checkNotNull((Object)this.kvStateRegistry, (String)"Can not register queryable state, because the registry is null.");
            this.kvStateRegistry.registerKvState(this.internalStateBackend.getKeyGroupRange(), stateDesc.getQueryableStateName(), (InternalKvState)state);
        }
    }
}

