/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.context.ContextSubKeyedAppendingState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalFoldingState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueState;
import org.apache.flink.util.Preconditions;

public class ContextSubKeyedFoldingState<K, N, T, ACC>
implements ContextSubKeyedAppendingState<K, N, T, ACC, ACC>,
InternalFoldingState<K, N, T, ACC> {
    private N namespace;
    private final KeyContextImpl<K> operator;
    private final SubKeyedValueState<Object, N, ACC> subKeyedValueState;
    private final FoldingStateDescriptor<T, ACC> stateDescriptor;
    private final FoldTransformation foldTransformation;

    public ContextSubKeyedFoldingState(KeyContextImpl<K> operator, SubKeyedValueState<Object, N, ACC> subKeyedValueState, FoldingStateDescriptor<T, ACC> stateDescriptor) {
        Preconditions.checkNotNull(operator);
        Preconditions.checkNotNull(subKeyedValueState);
        Preconditions.checkNotNull(stateDescriptor);
        this.operator = operator;
        this.subKeyedValueState = subKeyedValueState;
        this.stateDescriptor = stateDescriptor;
        this.foldTransformation = new FoldTransformation(stateDescriptor.getFoldFunction());
    }

    public ACC get() {
        return (ACC)this.subKeyedValueState.get(this.operator.getCurrentKey(), this.namespace);
    }

    public void add(T value) {
        this.subKeyedValueState.transform(this.operator.getCurrentKey(), this.namespace, value, this.foldTransformation);
    }

    public void clear() {
        this.subKeyedValueState.remove(this.operator.getCurrentKey(), this.namespace);
    }

    private ACC getInitialValue() {
        return (ACC)this.stateDescriptor.getInitialValue();
    }

    @Override
    public SubKeyedState getSubKeyedState() {
        return this.subKeyedValueState;
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.operator.getKeySerializer();
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.subKeyedValueState.getDescriptor().getNamespaceSerializer();
    }

    @Override
    public TypeSerializer<ACC> getValueSerializer() {
        return this.subKeyedValueState.getDescriptor().getValueSerializer();
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        this.namespace = namespace;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<ACC> safeValueSerializer) throws Exception {
        return new byte[0];
    }

    private final class FoldTransformation
    implements StateTransformationFunction<ACC, T> {
        private final FoldFunction<T, ACC> foldFunction;

        FoldTransformation(FoldFunction<T, ACC> foldFunction) {
            this.foldFunction = (FoldFunction)Preconditions.checkNotNull(foldFunction);
        }

        @Override
        public ACC apply(ACC previousState, T value) throws Exception {
            return this.foldFunction.fold(previousState != null ? previousState : ContextSubKeyedFoldingState.this.getInitialValue(), value);
        }
    }
}

