/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.context;

import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.context.ContextSubKeyedAppendingState;
import org.apache.flink.runtime.state.heap.KeyContextImpl;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedState;

public class ContextSubKeyedListState<K, N, E>
implements ContextSubKeyedAppendingState<K, N, E, List<E>, Iterable<E>>,
InternalListState<K, N, E> {
    private N namespace;
    private final KeyContextImpl<K> keyContext;
    private final SubKeyedListState<Object, N, E> subKeyedListState;

    public ContextSubKeyedListState(KeyContextImpl<K> keyContext, SubKeyedListState<Object, N, E> subKeyedListState) {
        this.keyContext = keyContext;
        this.subKeyedListState = subKeyedListState;
    }

    public Iterable<E> get() throws Exception {
        return (Iterable)this.subKeyedListState.get(this.getCurrentKey(), this.namespace);
    }

    public void add(E value) throws Exception {
        this.subKeyedListState.add(this.getCurrentKey(), this.namespace, value);
    }

    public void clear() {
        this.subKeyedListState.remove(this.getCurrentKey(), this.namespace);
    }

    private Object getCurrentKey() {
        return this.keyContext.getCurrentKey();
    }

    @Override
    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        if (sources != null) {
            for (N source : sources) {
                List list = (List)this.subKeyedListState.get(this.getCurrentKey(), source);
                if (list == null) continue;
                this.subKeyedListState.addAll(this.getCurrentKey(), target, list);
                this.subKeyedListState.remove(this.getCurrentKey(), source);
            }
        }
    }

    @Override
    public void update(List<E> values) {
        if (values == null || values.isEmpty()) {
            this.subKeyedListState.remove(this.getCurrentKey(), this.namespace);
        } else {
            this.subKeyedListState.putAll(this.getCurrentKey(), this.namespace, values);
        }
    }

    @Override
    public void addAll(List<E> values) {
        if (values != null && !values.isEmpty()) {
            this.subKeyedListState.addAll(this.getCurrentKey(), this.namespace, values);
        }
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keyContext.getKeySerializer();
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.subKeyedListState.getDescriptor().getNamespaceSerializer();
    }

    @Override
    public TypeSerializer<List<E>> getValueSerializer() {
        return this.subKeyedListState.getDescriptor().getValueSerializer();
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        this.namespace = namespace;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<List<E>> safeValueSerializer) throws Exception {
        return new byte[0];
    }

    @Override
    public SubKeyedState getSubKeyedState() {
        return this.subKeyedListState;
    }
}

