/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.runtime.state.AbstractInternalStateBackend;
import org.apache.flink.runtime.state.RegisteredStateMetaInfo;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.StorageInstance;
import org.apache.flink.runtime.state.StorageIterator;
import org.apache.flink.runtime.state.heap.HeapStorageIterator;
import org.apache.flink.runtime.state.heap.internal.CopyOnWriteStateTable;
import org.apache.flink.runtime.state.heap.internal.NestedMapsStateTable;
import org.apache.flink.runtime.state.heap.internal.StateTable;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public class HeapStateStorage<K, N, S>
implements StateStorage<K, S> {
    private final StateTable<K, N, S> stateTable;
    private N currentNamespace;

    public HeapStateStorage(AbstractInternalStateBackend stateBackend, RegisteredStateMetaInfo stateMetaInfo, N defaultNamespace, boolean usingNamespace, boolean asynchronous) {
        Preconditions.checkNotNull((Object)stateBackend);
        Preconditions.checkNotNull((Object)stateMetaInfo);
        this.currentNamespace = defaultNamespace;
        this.stateTable = asynchronous ? new CopyOnWriteStateTable(stateBackend, stateMetaInfo, usingNamespace) : new NestedMapsStateTable(stateBackend, stateMetaInfo, usingNamespace);
    }

    @Override
    public void put(K key, S state) {
        this.stateTable.put(key, this.currentNamespace, state);
    }

    @Override
    public S get(K key) {
        return this.stateTable.get(key, this.currentNamespace);
    }

    @Override
    public boolean remove(K key) {
        return this.stateTable.remove(key, this.currentNamespace);
    }

    @Override
    public StorageIterator<K, S> iterator() {
        return new HeapStorageIterator(this.stateTable.entryIterator());
    }

    @Override
    public StorageIterator<K, S> prefixIterator(K prefixKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StorageIterator<K, S> subIterator(K prefixKeyStart, K prefixKeyEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Pair<K, S> firstEntry(K prefixKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Pair<K, S> lastEntry(K prefixKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void merge(K key, S state) {
        throw new UnsupportedOperationException();
    }

    public <T> void transform(K key, T value, StateTransformationFunction<S, T> transformation) throws Exception {
        this.stateTable.transform(key, this.currentNamespace, value, transformation);
    }

    @Override
    public boolean lazySerde() {
        return true;
    }

    @Override
    public boolean supportMultiColumnFamilies() {
        return false;
    }

    @Override
    public StorageInstance getStorageInstance() {
        throw new UnsupportedOperationException("HeapStateStorage does not have StorageInstance");
    }

    public S getAndRemove(K key) {
        return this.stateTable.removeAndGetOld(key, this.currentNamespace);
    }

    public Map<N, S> getAll(K key) {
        return this.stateTable.getAll(key);
    }

    public void removeAll(K key) {
        this.stateTable.removeAll(key);
    }

    public void removeAll() {
        this.stateTable.removeAll();
    }

    public StateTable getStateTable() {
        return this.stateTable;
    }

    public void setCurrentNamespace(N namespace) {
        this.currentNamespace = Preconditions.checkNotNull(namespace);
    }

    public void setStateMetaInfo(RegisteredStateMetaInfo stateMetaInfo) {
        this.stateTable.setStateMetaInfo(stateMetaInfo);
    }

    public Iterator<N> namespaceIterator(K key) {
        return this.stateTable.namespaceIterator(key);
    }
}

