/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.runtime.state.StorageIterator;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public class HeapStorageIterator<K, V>
implements StorageIterator<K, V> {
    private final Iterator<Map.Entry<K, V>> iterator;

    public HeapStorageIterator(Iterator<Map.Entry<K, V>> iterator) {
        this.iterator = (Iterator)Preconditions.checkNotNull(iterator);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Pair<K, V> next() {
        return new HeapPair<K, V>(this.iterator.next());
    }

    @Override
    public void close() {
    }

    public static class HeapPair<K, V>
    implements Pair<K, V> {
        private final Map.Entry<K, V> entry;

        public HeapPair(Map.Entry<K, V> entry) {
            this.entry = (Map.Entry)Preconditions.checkNotNull(entry);
        }

        public K getKey() {
            return this.entry.getKey();
        }

        public V getValue() {
            return this.entry.getValue();
        }

        public V setValue(V value) {
            return this.entry.setValue(value);
        }
    }
}

