/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.keyed;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.HashPartitioner;
import org.apache.flink.api.common.typeutils.SerializationException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.state.AbstractInternalStateBackend;
import org.apache.flink.runtime.state.GroupIterator;
import org.apache.flink.runtime.state.StateAccessException;
import org.apache.flink.runtime.state.StateIteratorUtil;
import org.apache.flink.runtime.state.StateSerializerUtil;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.StorageIterator;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.heap.HeapStateStorage;
import org.apache.flink.runtime.state.keyed.KeyedListState;
import org.apache.flink.runtime.state.keyed.KeyedListStateDescriptor;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public final class KeyedListStateImpl<K, E>
implements KeyedListState<K, E> {
    private final KeyedListStateDescriptor<K, E> descriptor;
    private final StateStorage stateStorage;
    private TypeSerializer<E> elementSerializer;
    private TypeSerializer<K> keySerializer;
    private final byte[] stateNameByte;
    private final byte[] stateNameForSerialize;
    private AbstractInternalStateBackend internalStateBackend;
    private static final HashPartitioner partitioner = HashPartitioner.INSTANCE;
    private ByteArrayOutputStreamWithPos outputStream = new ByteArrayOutputStreamWithPos();
    private DataOutputView outputView = new DataOutputViewStreamWrapper((OutputStream)this.outputStream);

    public KeyedListStateImpl(AbstractInternalStateBackend backend, KeyedListStateDescriptor<K, E> descriptor, StateStorage stateStorage) {
        this.stateStorage = (StateStorage)Preconditions.checkNotNull((Object)stateStorage);
        this.descriptor = (KeyedListStateDescriptor)Preconditions.checkNotNull(descriptor);
        this.elementSerializer = descriptor.getElementSerializer();
        this.keySerializer = descriptor.getKeySerializer();
        this.internalStateBackend = (AbstractInternalStateBackend)Preconditions.checkNotNull((Object)backend);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            StringSerializer.INSTANCE.serialize(descriptor.getName(), (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            this.stateNameByte = out.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
        this.stateNameForSerialize = stateStorage.supportMultiColumnFamilies() ? null : this.stateNameByte;
    }

    @Override
    public KeyedListStateDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public StateStorage<K, List<E>> getStateStorage() {
        return this.stateStorage;
    }

    @Override
    public boolean contains(K key) {
        List<E> list = this.getOrDefault(key, null);
        return list != null;
    }

    @Override
    public List<E> get(K key) {
        return this.getOrDefault(key, null);
    }

    @Override
    public List<E> getOrDefault(K key, List<E> defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                List value = (List)this.stateStorage.get(key);
                return value == null ? defaultValue : value;
            }
            byte[] serializedValue = this.getSerializedValue(key, this.outputStream, this.outputView, this.keySerializer);
            if (serializedValue == null) {
                return defaultValue;
            }
            return StateSerializerUtil.getDeserializeList(serializedValue, this.elementSerializer);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Map<K, List<E>> getAll(Collection<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, Object> results = new HashMap<K, Object>(keys.size());
        for (K key : keys) {
            Object result;
            if (key == null || (result = this.get((Object)key)) == null || result.isEmpty()) continue;
            results.put(key, result);
        }
        return results;
    }

    @Override
    public void add(K key, E element) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(element, (String)"You can not add null value to list state.");
        try {
            if (this.stateStorage.lazySerde()) {
                ArrayList<E> list = (ArrayList<E>)this.stateStorage.get(key);
                if (list == null) {
                    list = new ArrayList<E>();
                    this.stateStorage.put(key, list);
                }
                list.add(element);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                this.outputStream.reset();
                this.elementSerializer.serialize(element, this.outputView);
                byte[] serializedValue = this.outputStream.toByteArray();
                this.stateStorage.merge(serializedKey, serializedValue);
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void addAll(K key, Collection<? extends E> elements) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(elements, (String)"List of values to add cannot be null.");
        if (elements.isEmpty()) {
            return;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                ((HeapStateStorage)this.stateStorage).transform(key, elements, (previousState, value) -> {
                    if (previousState == null) {
                        previousState = new ArrayList();
                    }
                    for (Object v : elements) {
                        Preconditions.checkNotNull(v, (String)"You cannot add null to a ListState.");
                        ((List)previousState).add(v);
                    }
                    return previousState;
                });
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                this.outputStream.reset();
                StateSerializerUtil.getPreMergedList(this.outputView, elements, this.elementSerializer);
                byte[] preMergedValue = this.outputStream.toByteArray();
                this.stateStorage.merge(serializedKey, preMergedValue);
            }
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                throw (NullPointerException)e;
            }
            throw new StateAccessException(e);
        }
    }

    @Override
    public void addAll(Map<? extends K, ? extends Collection<? extends E>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<K, Collection<E>> entry : map.entrySet()) {
            this.addAll(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void put(K key, E element) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(element, (String)"You can not add null value to list state.");
        try {
            if (this.stateStorage.lazySerde()) {
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(element));
                this.stateStorage.put(key, list);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                this.outputStream.reset();
                this.elementSerializer.serialize(element, this.outputView);
                byte[] serializedValue = this.outputStream.toByteArray();
                this.stateStorage.put(serializedKey, serializedValue);
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void putAll(K key, Collection<? extends E> elements) {
        Preconditions.checkNotNull(key);
        try {
            if (this.stateStorage.lazySerde()) {
                ArrayList<E> list = new ArrayList<E>();
                for (E element : elements) {
                    Preconditions.checkNotNull(element, (String)"You cannot add null to a ListState.");
                    list.add(element);
                }
                this.stateStorage.put(key, list);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                this.outputStream.reset();
                StateSerializerUtil.getPreMergedList(this.outputView, elements, this.elementSerializer);
                byte[] preMergedValue = this.outputStream.toByteArray();
                this.stateStorage.put(serializedKey, preMergedValue);
            }
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                throw (NullPointerException)e;
            }
            throw new StateAccessException(e);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends Collection<? extends E>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<K, Collection<E>> entry : map.entrySet()) {
            this.putAll(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void remove(K key) {
        if (key == null) {
            return;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                this.stateStorage.remove(key);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                this.stateStorage.remove(serializedKey);
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public boolean remove(K key, E elementToRemove) {
        if (key == null) {
            return false;
        }
        try {
            boolean success = false;
            if (this.stateStorage.lazySerde()) {
                Object list = this.get((Object)key);
                if (list != null) {
                    success = list.remove(elementToRemove);
                    if (list.isEmpty()) {
                        this.remove(key);
                    }
                }
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                byte[] serializedValue = (byte[])this.stateStorage.get(serializedKey);
                if (serializedValue == null) {
                    success = false;
                } else {
                    List<E> list = StateSerializerUtil.getDeserializeList(serializedValue, this.elementSerializer);
                    success = list.remove(elementToRemove);
                    if (list.isEmpty()) {
                        this.stateStorage.remove(serializedKey);
                    } else {
                        this.outputStream.reset();
                        StateSerializerUtil.getPreMergedList(this.outputView, list, this.elementSerializer);
                        byte[] preMergedValueValue = this.outputStream.toByteArray();
                        this.stateStorage.put(serializedKey, preMergedValueValue);
                    }
                }
            }
            return success;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void removeAll(Collection<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (K key : keys) {
            this.remove(key);
        }
    }

    @Override
    public boolean removeAll(K key, Collection<? extends E> elementsToRemove) {
        if (key == null) {
            return false;
        }
        try {
            boolean success = false;
            if (this.stateStorage.lazySerde()) {
                Object value = this.get((Object)key);
                if (value != null) {
                    success = value.removeAll(elementsToRemove);
                    if (value.isEmpty()) {
                        this.remove(key);
                    }
                }
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                byte[] serializedValue = (byte[])this.stateStorage.get(serializedKey);
                if (serializedValue == null) {
                    success = false;
                } else {
                    List<E> preList = StateSerializerUtil.getDeserializeList(serializedValue, this.elementSerializer);
                    success = preList.removeAll(elementsToRemove);
                    if (preList.isEmpty()) {
                        this.stateStorage.remove(serializedKey);
                    } else {
                        this.outputStream.reset();
                        StateSerializerUtil.getPreMergedList(this.outputView, preList, this.elementSerializer);
                        byte[] preMergedValueValue = this.outputStream.toByteArray();
                        this.stateStorage.put(serializedKey, preMergedValueValue);
                    }
                }
            }
            return success;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public boolean removeAll(Map<? extends K, ? extends Collection<? extends E>> map) {
        if (map == null || map.isEmpty()) {
            return false;
        }
        boolean success = false;
        for (Map.Entry<K, Collection<E>> entry : map.entrySet()) {
            Collection<? extends E> elements;
            K key = entry.getKey();
            success = this.removeAll(key, elements = entry.getValue()) || success;
        }
        return success;
    }

    @Override
    public Map<K, List<E>> getAll() {
        try {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            if (this.stateStorage.lazySerde()) {
                StorageIterator iterator = this.stateStorage.iterator();
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    result.put(pair.getKey(), pair.getValue());
                }
            } else if (!this.stateStorage.supportMultiColumnFamilies() && this.internalStateBackend.getStateStorages().size() > 1) {
                for (Integer group : this.internalStateBackend.getKeyGroupRange()) {
                    this.outputStream.reset();
                    StateSerializerUtil.serializeGroupPrefix(this.outputStream, group, this.stateNameByte);
                    byte[] groupPrefix = this.outputStream.toByteArray();
                    this.outputStream.write(127);
                    byte[] groupPrefixEnd = this.outputStream.toByteArray();
                    StorageIterator iterator = this.stateStorage.subIterator(groupPrefix, groupPrefixEnd);
                    while (iterator.hasNext()) {
                        Pair pair = (Pair)iterator.next();
                        K key = StateSerializerUtil.getDeserializedKeyForKeyedListState((byte[])pair.getKey(), this.keySerializer, this.stateNameByte.length);
                        List<E> list = StateSerializerUtil.getDeserializeList((byte[])pair.getValue(), this.elementSerializer);
                        result.put(key, list);
                    }
                }
            } else {
                StorageIterator iterator = this.stateStorage.iterator();
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    K key = StateSerializerUtil.getDeserializedKeyForKeyedListState((byte[])pair.getKey(), this.keySerializer, this.stateStorage.supportMultiColumnFamilies() ? 0 : this.stateNameByte.length);
                    List<E> list = StateSerializerUtil.getDeserializeList((byte[])pair.getValue(), this.elementSerializer);
                    result.put(key, list);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void removeAll() {
        if (this.stateStorage.lazySerde()) {
            ((HeapStateStorage)this.stateStorage).removeAll();
        } else {
            try {
                if (!this.stateStorage.supportMultiColumnFamilies() && this.internalStateBackend.getStateStorages().size() > 1) {
                    for (Integer group : this.internalStateBackend.getKeyGroupRange()) {
                        this.outputStream.reset();
                        StateSerializerUtil.serializeGroupPrefix(this.outputStream, group, this.stateNameByte);
                        byte[] groupPrefix = this.outputStream.toByteArray();
                        this.outputStream.write(127);
                        byte[] groupPrefixEnd = this.outputStream.toByteArray();
                        StorageIterator iterator = this.stateStorage.subIterator(groupPrefix, groupPrefixEnd);
                        while (iterator.hasNext()) {
                            iterator.next();
                            iterator.remove();
                        }
                    }
                } else {
                    StorageIterator iterator = this.stateStorage.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                }
            }
            catch (Exception e) {
                throw new StateAccessException(e);
            }
        }
    }

    @Override
    public Iterable<K> keys() {
        return new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                try {
                    if (KeyedListStateImpl.this.stateStorage.lazySerde()) {
                        final StorageIterator iterator = KeyedListStateImpl.this.stateStorage.iterator();
                        return new Iterator<K>(){

                            @Override
                            public boolean hasNext() {
                                return iterator.hasNext();
                            }

                            @Override
                            public K next() {
                                return ((Pair)iterator.next()).getKey();
                            }

                            @Override
                            public void remove() {
                                iterator.remove();
                            }
                        };
                    }
                    if (!KeyedListStateImpl.this.stateStorage.supportMultiColumnFamilies() && KeyedListStateImpl.this.internalStateBackend.getStateStorages().size() > 1) {
                        ArrayList<Iterator<Pair<byte[], byte[]>>> groupIterators = new ArrayList<Iterator<Pair<byte[], byte[]>>>();
                        for (Integer group : KeyedListStateImpl.this.internalStateBackend.getKeyGroupRange()) {
                            KeyedListStateImpl.this.outputStream.reset();
                            StateSerializerUtil.serializeGroupPrefix(KeyedListStateImpl.this.outputStream, group, KeyedListStateImpl.this.stateNameByte);
                            byte[] groupPrefix = KeyedListStateImpl.this.outputStream.toByteArray();
                            KeyedListStateImpl.this.outputStream.write(127);
                            byte[] groupPrefixEnd = KeyedListStateImpl.this.outputStream.toByteArray();
                            StorageIterator iterator = KeyedListStateImpl.this.stateStorage.subIterator(groupPrefix, groupPrefixEnd);
                            groupIterators.add(iterator);
                        }
                        GroupIterator groupIterator = new GroupIterator(groupIterators);
                        return StateIteratorUtil.createKeyIterator(groupIterator, KeyedListStateImpl.this.keySerializer, KeyedListStateImpl.this.stateNameByte.length);
                    }
                    StorageIterator<byte[], byte[]> iterator = KeyedListStateImpl.this.stateStorage.iterator();
                    return StateIteratorUtil.createKeyIterator(iterator, KeyedListStateImpl.this.keySerializer, KeyedListStateImpl.this.stateStorage.supportMultiColumnFamilies() ? 0 : KeyedListStateImpl.this.stateNameByte.length);
                }
                catch (Exception e) {
                    throw new StateAccessException(e);
                }
            }
        };
    }

    @Override
    public E poll(K key) {
        try {
            if (this.stateStorage.lazySerde()) {
                List value = (List)this.stateStorage.get(key);
                if (value == null) {
                    return null;
                }
                Object element = value.remove(0);
                if (value.isEmpty()) {
                    this.stateStorage.remove(key);
                }
                return element;
            }
            Object value = this.get((Object)key);
            if (value == null) {
                return null;
            }
            Object element = value.remove(0);
            if (value.isEmpty()) {
                this.remove(key);
            } else {
                this.putAll(key, (Collection<? extends E>)value);
            }
            return element;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public E peek(K key) {
        Object list = this.get((Object)key);
        E element = null;
        if (list != null) {
            element = list.get(0);
        }
        return element;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<List<E>> safeValueSerializer) throws Exception {
        Object key = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, safeKeySerializer, (TypeSerializer)VoidNamespaceSerializer.INSTANCE).f0;
        ByteArrayOutputStreamWithPos baos = new ByteArrayOutputStreamWithPos();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)baos);
        if (this.stateStorage.lazySerde()) {
            Object value = this.get(key);
            if (value == null) {
                return null;
            }
            TypeSerializer dupSerializer = ((ListSerializer)safeValueSerializer).getElementSerializer();
            for (int i = 0; i < value.size(); ++i) {
                dupSerializer.serialize(value.get(i), (DataOutputView)view);
                if (i >= value.size() - 1) continue;
                view.writeByte(44);
            }
            view.flush();
            return baos.toByteArray();
        }
        return this.getSerializedValue(key, baos, (DataOutputView)view, safeKeySerializer);
    }

    private <K> int getKeyGroup(K key) {
        return partitioner.partition(key, this.internalStateBackend.getNumGroups());
    }

    private byte[] getSerializedValue(K key, ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, TypeSerializer<K> safeKeySerializer) throws Exception {
        outputStream.reset();
        byte[] serializedKey = StateSerializerUtil.getSerializedKeyForKeyedListState(outputStream, outputView, key, safeKeySerializer, this.getKeyGroup(key), this.stateNameForSerialize);
        return (byte[])this.stateStorage.get(serializedKey);
    }
}

