/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.keyed;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeutils.SerializationException;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.AbstractInternalStateBackend;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.keyed.AbstractKeyedMapStateImpl;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.runtime.state.keyed.KeyedMapStateDescriptor;
import org.apache.flink.util.Preconditions;

public final class KeyedMapStateImpl<K, MK, MV>
extends AbstractKeyedMapStateImpl<K, MK, MV, Map<MK, MV>>
implements KeyedMapState<K, MK, MV> {
    private KeyedMapStateDescriptor<K, MK, MV> stateDescriptor;

    public KeyedMapStateImpl(AbstractInternalStateBackend internalStateBackend, KeyedMapStateDescriptor<K, MK, MV> descriptor, StateStorage stateStorage) {
        super(internalStateBackend, stateStorage);
        this.stateDescriptor = (KeyedMapStateDescriptor)Preconditions.checkNotNull(descriptor);
        this.keySerializer = descriptor.getKeySerializer();
        this.mapKeySerializer = descriptor.getMapKeySerializer();
        this.mapValueSerializer = descriptor.getMapValueSerializer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            StringSerializer.INSTANCE.serialize(descriptor.getName(), (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            this.stateNameByte = out.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
        this.stateNameForSerialize = stateStorage.supportMultiColumnFamilies() ? null : this.stateNameByte;
        this.serializedStateNameLength = this.stateNameForSerialize == null ? 0 : this.stateNameForSerialize.length;
    }

    @Override
    public KeyedMapStateDescriptor getDescriptor() {
        return this.stateDescriptor;
    }

    @Override
    Map<MK, MV> createMap() {
        return new HashMap();
    }
}

