/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.subkeyed;

import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.runtime.state.InternalStateType;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateBinder;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateDescriptor;
import org.apache.flink.util.Preconditions;

public final class SubKeyedListStateDescriptor<K, N, E>
extends SubKeyedStateDescriptor<K, N, List<E>, SubKeyedListState<K, N, E>> {
    private static final long serialVersionUID = 1L;

    public SubKeyedListStateDescriptor(String name, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<E> elementSerializer) {
        super(name, InternalStateType.SUBKEYED_LIST, keySerializer, namespaceSerializer, new ListSerializer(elementSerializer));
    }

    @Override
    public ListSerializer<E> getValueSerializer() {
        TypeSerializer listSerializer = super.getValueSerializer();
        Preconditions.checkState((boolean)(listSerializer instanceof ListSerializer));
        return (ListSerializer)listSerializer;
    }

    public TypeSerializer<E> getElementSerializer() {
        return this.getValueSerializer().getElementSerializer();
    }

    @Override
    public SubKeyedListState<K, N, E> bind(SubKeyedStateBinder stateBinder) throws Exception {
        return stateBinder.createSubKeyedListState(this);
    }
}

