/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.subkeyed;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.HashPartitioner;
import org.apache.flink.api.common.typeutils.SerializationException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.state.AbstractInternalStateBackend;
import org.apache.flink.runtime.state.StateAccessException;
import org.apache.flink.runtime.state.StateSerializerUtil;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.StorageIterator;
import org.apache.flink.runtime.state.heap.HeapStateStorage;
import org.apache.flink.runtime.state.heap.internal.StateTable;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedListStateDescriptor;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public final class SubKeyedListStateImpl<K, N, E>
implements SubKeyedListState<K, N, E> {
    private final SubKeyedListStateDescriptor<K, N, E> descriptor;
    private final StateStorage stateStorage;
    private AbstractInternalStateBackend internalStateBackend;
    private TypeSerializer<K> keySerializer;
    private TypeSerializer<N> namespaceSerializer;
    private TypeSerializer<E> elementSerializer;
    private final byte[] stateNameByte;
    private final byte[] stateNameForSerialize;
    private final int serializedStateNameLength;
    private ByteArrayOutputStreamWithPos outputStream = new ByteArrayOutputStreamWithPos();
    private DataOutputView outputView = new DataOutputViewStreamWrapper((OutputStream)this.outputStream);
    protected final HashPartitioner partitioner = HashPartitioner.INSTANCE;

    public SubKeyedListStateImpl(AbstractInternalStateBackend internalStateBackend, SubKeyedListStateDescriptor<K, N, E> descriptor, StateStorage stateStorage) {
        this.internalStateBackend = (AbstractInternalStateBackend)Preconditions.checkNotNull((Object)internalStateBackend);
        this.descriptor = (SubKeyedListStateDescriptor)Preconditions.checkNotNull(descriptor);
        this.stateStorage = (StateStorage)Preconditions.checkNotNull((Object)stateStorage);
        this.keySerializer = descriptor.getKeySerializer();
        this.namespaceSerializer = descriptor.getNamespaceSerializer();
        this.elementSerializer = descriptor.getElementSerializer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            StringSerializer.INSTANCE.serialize(descriptor.getName(), (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            this.stateNameByte = out.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
        this.stateNameForSerialize = stateStorage.supportMultiColumnFamilies() ? null : this.stateNameByte;
        this.serializedStateNameLength = this.stateNameForSerialize == null ? 0 : this.stateNameForSerialize.length;
    }

    @Override
    public SubKeyedListStateDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean contains(K key, N namespace) {
        if (key == null || namespace == null) {
            return false;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                return this.getOrDefault(key, namespace, null) != null;
            }
            this.outputStream.reset();
            byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            return this.stateStorage.get(serializedKey) != null;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public List<E> get(K key, N namespace) {
        return this.getOrDefault(key, namespace, null);
    }

    @Override
    public List<E> getOrDefault(K key, N namespace, List<E> defaultList) {
        if (key == null || namespace == null) {
            return defaultList;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                List value = (List)heapStateStorage.get(key);
                return value == null ? defaultList : value;
            }
            byte[] serializedValue = this.getSerializedValue(key, namespace, this.outputStream, this.outputView, this.keySerializer, this.namespaceSerializer);
            if (serializedValue == null) {
                return defaultList;
            }
            return StateSerializerUtil.getDeserializeList(serializedValue, this.elementSerializer);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Map<N, List<E>> getAll(K key) {
        if (key == null) {
            return Collections.emptyMap();
        }
        try {
            if (this.stateStorage.lazySerde()) {
                return ((HeapStateStorage)this.stateStorage).getAll(key);
            }
            HashMap<N, List<E>> result = new HashMap<N, List<E>>();
            this.outputStream.reset();
            byte[] prefix = StateSerializerUtil.getSerializedPrefixKeyForSubKeyedState(this.outputStream, this.outputView, key, this.keySerializer, null, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            StorageIterator iterator = this.stateStorage.prefixIterator(prefix);
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                byte[] byteKey = (byte[])pair.getKey();
                byte[] byteValue = (byte[])pair.getValue();
                N currentNamespace = StateSerializerUtil.getDeserializedNamespcae(byteKey, this.keySerializer, this.namespaceSerializer, this.stateStorage.supportMultiColumnFamilies() ? 0 : this.stateNameByte.length);
                List<E> currentValue = StateSerializerUtil.getDeserializeList(byteValue, this.elementSerializer);
                result.put(currentNamespace, currentValue);
            }
            return result;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void add(K key, N namespace, E element) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        Preconditions.checkNotNull(element);
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                ArrayList<E> list = (ArrayList<E>)heapStateStorage.get(key);
                if (list == null) {
                    list = new ArrayList<E>();
                    heapStateStorage.put(key, list);
                }
                list.add(element);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                this.outputStream.reset();
                this.elementSerializer.serialize(element, this.outputView);
                byte[] serializedValue = this.outputStream.toByteArray();
                this.stateStorage.merge(serializedKey, serializedValue);
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void addAll(K key, N namespace, Collection<? extends E> elements) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        Preconditions.checkNotNull(elements);
        if (elements.isEmpty()) {
            return;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                heapStateStorage.transform(key, elements, (previousState, value) -> {
                    if (previousState == null) {
                        previousState = new ArrayList();
                    }
                    for (Object v : elements) {
                        Preconditions.checkNotNull(v, (String)"You cannot add null to a ListState.");
                        ((List)previousState).add(v);
                    }
                    return previousState;
                });
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                this.outputStream.reset();
                StateSerializerUtil.getPreMergedList(this.outputView, elements, this.elementSerializer);
                byte[] preMergedValue = this.outputStream.toByteArray();
                this.stateStorage.merge(serializedKey, preMergedValue);
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void put(K key, N namespace, E element) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        Preconditions.checkNotNull(element);
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                heapStateStorage.put(key, Arrays.asList(element));
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                this.outputStream.reset();
                this.elementSerializer.serialize(element, this.outputView);
                byte[] serilizedValue = this.outputStream.toByteArray();
                this.stateStorage.put(serializedKey, serilizedValue);
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void putAll(K key, N namespace, Collection<? extends E> elements) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        Preconditions.checkNotNull(elements);
        if (elements.isEmpty()) {
            return;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                ArrayList<E> list = new ArrayList<E>();
                for (E element : elements) {
                    Preconditions.checkNotNull(element, (String)"You cannot add null to a ListState.");
                    list.add(element);
                }
                heapStateStorage.put(key, list);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                this.outputStream.reset();
                StateSerializerUtil.getPreMergedList(this.outputView, elements, this.elementSerializer);
                byte[] preMergedValue = this.outputStream.toByteArray();
                this.stateStorage.put(serializedKey, preMergedValue);
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void remove(K key, N namespace) {
        if (key == null || namespace == null) {
            return;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                heapStateStorage.remove(key);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                this.stateStorage.remove(serializedKey);
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public boolean remove(K key, N namespace, E elementToRemove) {
        if (key == null || namespace == null) {
            return false;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                boolean success = false;
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                List value = (List)heapStateStorage.get(key);
                if (value != null) {
                    success = value.remove(elementToRemove);
                    if (value.isEmpty()) {
                        heapStateStorage.remove(key);
                    }
                }
                return success;
            }
            this.outputStream.reset();
            byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            byte[] byteValue = (byte[])this.stateStorage.get(serializedKey);
            if (byteValue == null) {
                return false;
            }
            List<E> list = StateSerializerUtil.getDeserializeList(byteValue, this.elementSerializer);
            boolean success = list.remove(elementToRemove);
            if (list.isEmpty()) {
                this.stateStorage.remove(serializedKey);
            } else {
                this.putAll(key, namespace, list);
            }
            return success;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public boolean removeAll(K key, N namespace, Collection<? extends E> elements) {
        if (key == null || namespace == null || elements == null || elements.isEmpty()) {
            return false;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                boolean success = false;
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                List value = (List)heapStateStorage.get(key);
                if (value != null) {
                    success = value.removeAll(elements);
                    if (value.isEmpty()) {
                        heapStateStorage.remove(key);
                    }
                }
                return success;
            }
            this.outputStream.reset();
            byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedListState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            byte[] byteValue = (byte[])this.stateStorage.get(serializedKey);
            if (byteValue == null) {
                return false;
            }
            List<E> list = StateSerializerUtil.getDeserializeList(byteValue, this.elementSerializer);
            boolean success = list.removeAll(elements);
            if (list.isEmpty()) {
                this.stateStorage.remove(serializedKey);
            } else {
                this.putAll(key, namespace, list);
            }
            return success;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void removeAll(K key) {
        if (key == null) {
            return;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                ((HeapStateStorage)this.stateStorage).removeAll(key);
            } else {
                this.outputStream.reset();
                byte[] prefix = StateSerializerUtil.getSerializedPrefixKeyForSubKeyedState(this.outputStream, this.outputView, key, this.keySerializer, null, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                StorageIterator iterator = this.stateStorage.prefixIterator(prefix);
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    this.stateStorage.remove(pair.getKey());
                }
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Iterator<N> iterator(K key) {
        Preconditions.checkNotNull(key);
        try {
            if (this.stateStorage.lazySerde()) {
                return ((HeapStateStorage)this.stateStorage).namespaceIterator(key);
            }
            this.outputStream.reset();
            byte[] prefix = StateSerializerUtil.getSerializedPrefixKeyForSubKeyedState(this.outputStream, this.outputView, key, this.keySerializer, null, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            final StorageIterator iterator = this.stateStorage.prefixIterator(prefix);
            return new Iterator<N>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public N next() {
                    try {
                        Object namespace = StateSerializerUtil.getDeserializedNamespcae((byte[])((Pair)iterator.next()).getKey(), SubKeyedListStateImpl.this.keySerializer, SubKeyedListStateImpl.this.namespaceSerializer, SubKeyedListStateImpl.this.stateStorage.supportMultiColumnFamilies() ? 0 : SubKeyedListStateImpl.this.stateNameByte.length);
                        return namespace;
                    }
                    catch (IOException e) {
                        throw new StateAccessException(e);
                    }
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Iterable<K> keys(N namespace) {
        Preconditions.checkNotNull(namespace);
        Set<Object> keys = new HashSet();
        if (this.stateStorage.lazySerde()) {
            StateTable stateTable = ((HeapStateStorage)this.stateStorage).getStateTable();
            keys = stateTable.getKeys(namespace).collect(Collectors.toSet());
        } else {
            try {
                for (int group : this.internalStateBackend.getKeyGroupRange()) {
                    this.outputStream.reset();
                    StateSerializerUtil.serializeGroupPrefix(this.outputStream, group, this.stateNameForSerialize);
                    StorageIterator iterator = this.stateStorage.prefixIterator(this.outputStream.toByteArray());
                    while (iterator.hasNext()) {
                        Pair pair = (Pair)iterator.next();
                        Pair<K, N> keyAndNamespace = StateSerializerUtil.getDeserializedKeyAndNamespace((byte[])pair.getKey(), this.keySerializer, this.namespaceSerializer, this.serializedStateNameLength);
                        if (!namespace.equals(keyAndNamespace.getValue())) continue;
                        keys.add(keyAndNamespace.getKey());
                    }
                }
            }
            catch (Exception e) {
                throw new StateAccessException(e);
            }
        }
        return keys.isEmpty() ? null : keys;
    }

    @Override
    public StateStorage<K, List<E>> getStateStorage() {
        return this.stateStorage;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<List<E>> safeValueSerializer) throws Exception {
        Tuple2 tuple = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, safeKeySerializer, safeNamespaceSerializer);
        Object key = tuple.f0;
        Object namespace = tuple.f1;
        ByteArrayOutputStreamWithPos baos = new ByteArrayOutputStreamWithPos();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)baos);
        if (this.stateStorage.lazySerde()) {
            Object value = this.get(key, namespace);
            if (value == null) {
                return null;
            }
            TypeSerializer dupSerializer = ((ListSerializer)safeValueSerializer).getElementSerializer();
            for (int i = 0; i < value.size(); ++i) {
                dupSerializer.serialize(value.get(i), (DataOutputView)view);
                if (i >= value.size() - 1) continue;
                view.writeByte(44);
            }
            view.flush();
            return baos.toByteArray();
        }
        return this.getSerializedValue(key, namespace, baos, (DataOutputView)view, safeKeySerializer, safeNamespaceSerializer);
    }

    private byte[] getSerializedValue(K key, N namespace, ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) throws Exception {
        outputStream.reset();
        byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedListState(outputStream, outputView, key, keySerializer, namespace, namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
        return (byte[])this.stateStorage.get(serializedKey);
    }

    @Override
    public E poll(K key, N namespace) {
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                List value = (List)heapStateStorage.get(key);
                if (value == null) {
                    return null;
                }
                Object element = value.remove(0);
                if (value.isEmpty()) {
                    heapStateStorage.remove(key);
                }
                return element;
            }
            Object list = this.get((Object)key, (Object)namespace);
            if (list == null) {
                return null;
            }
            Iterator iterator = list.iterator();
            E result = null;
            if (iterator.hasNext()) {
                result = iterator.next();
                iterator.remove();
            }
            if (list.isEmpty()) {
                this.remove(key, namespace);
            } else {
                this.putAll(key, namespace, (Collection<? extends E>)list);
            }
            return result;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public E peek(K key, N namespace) {
        try {
            if (this.stateStorage.lazySerde()) {
                Object list = this.get((Object)key, (Object)namespace);
                return list == null ? null : (E)list.get(0);
            }
            Object list = this.get((Object)key, (Object)namespace);
            if (list == null) {
                return null;
            }
            Iterator iterator = list.iterator();
            E result = null;
            if (iterator.hasNext()) {
                result = iterator.next();
            }
            return result;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    private <K> int getKeyGroup(K key) {
        return this.partitioner.partition(key, this.internalStateBackend.getNumGroups());
    }
}

