/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.subkeyed;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeutils.SerializationException;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.state.AbstractInternalStateBackend;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.subkeyed.AbstractSubKeyedMapStateImpl;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapStateDescriptor;
import org.apache.flink.util.Preconditions;

public final class SubKeyedMapStateImpl<K, N, MK, MV>
extends AbstractSubKeyedMapStateImpl<K, N, MK, MV, Map<MK, MV>>
implements SubKeyedMapState<K, N, MK, MV> {
    private SubKeyedMapStateDescriptor stateDescriptor;

    public SubKeyedMapStateImpl(AbstractInternalStateBackend internalStateBackend, SubKeyedMapStateDescriptor descriptor, StateStorage stateStorage) {
        super(internalStateBackend, stateStorage);
        this.stateDescriptor = (SubKeyedMapStateDescriptor)Preconditions.checkNotNull((Object)descriptor);
        this.keySerializer = descriptor.getKeySerializer();
        this.namespaceSerializer = descriptor.getNamespaceSerializer();
        this.mapKeySerializer = descriptor.getMapKeySerializer();
        this.mapValueSerializer = descriptor.getMapValueSerializer();
        try {
            this.outputStream.reset();
            StringSerializer.INSTANCE.serialize(descriptor.getName(), this.outputView);
            this.stateNameByte = this.outputStream.toByteArray();
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
        this.stateNameForSerialize = stateStorage.supportMultiColumnFamilies() ? null : this.stateNameByte;
        this.serializedStateNameLength = this.stateNameForSerialize == null ? 0 : this.stateNameForSerialize.length;
    }

    @Override
    public SubKeyedMapStateDescriptor getDescriptor() {
        return this.stateDescriptor;
    }

    @Override
    Map<MK, MV> createMap() {
        return new HashMap();
    }
}

