/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.subkeyed;

import java.util.SortedMap;
import org.apache.flink.api.common.functions.Comparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.SortedMapSerializer;
import org.apache.flink.runtime.state.InternalStateType;
import org.apache.flink.runtime.state.subkeyed.SubKeyedSortedMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateBinder;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateDescriptor;
import org.apache.flink.util.Preconditions;

public final class SubKeyedSortedMapStateDescriptor<K, N, MK, MV>
extends SubKeyedStateDescriptor<K, N, SortedMap<MK, MV>, SubKeyedSortedMapState<K, N, MK, MV>> {
    private static final long serialVersionUID = 1L;

    public SubKeyedSortedMapStateDescriptor(String name, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, Comparator<MK> mapKeyComparator, TypeSerializer<MK> mapKeySerializer, TypeSerializer<MV> mapValueSerializer) {
        this(name, keySerializer, namespaceSerializer, new SortedMapSerializer(mapKeyComparator, mapKeySerializer, mapValueSerializer));
    }

    public SubKeyedSortedMapStateDescriptor(String name, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, SortedMapSerializer<MK, MV> sortedMapSerializer) {
        super(name, InternalStateType.SUBKEYED_SORTEDMAP, keySerializer, namespaceSerializer, sortedMapSerializer);
    }

    public SortedMapSerializer<MK, MV> getValueSerializer() {
        TypeSerializer sortedMapSerializer = super.getValueSerializer();
        Preconditions.checkState((boolean)(sortedMapSerializer instanceof SortedMapSerializer));
        return (SortedMapSerializer)sortedMapSerializer;
    }

    public Comparator<MK> getComparator() {
        return this.getValueSerializer().getComparator();
    }

    public TypeSerializer<MK> getMapKeySerializer() {
        SortedMapSerializer<MK, MV> sortedMapSerializer = this.getValueSerializer();
        return sortedMapSerializer.getKeySerializer();
    }

    public TypeSerializer<MV> getMapValueSerializer() {
        SortedMapSerializer<MK, MV> sortedMapSerializer = this.getValueSerializer();
        return sortedMapSerializer.getValueSerializer();
    }

    @Override
    public SubKeyedSortedMapState<K, N, MK, MV> bind(SubKeyedStateBinder stateBinder) throws Exception {
        return stateBinder.createSubKeyedSortedMapState(this);
    }
}

