/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.subkeyed;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.HashPartitioner;
import org.apache.flink.api.common.typeutils.SerializationException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.state.AbstractInternalStateBackend;
import org.apache.flink.runtime.state.StateAccessException;
import org.apache.flink.runtime.state.StateSerializerUtil;
import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.StorageIterator;
import org.apache.flink.runtime.state.heap.HeapStateStorage;
import org.apache.flink.runtime.state.heap.internal.StateTable;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueStateDescriptor;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public final class SubKeyedValueStateImpl<K, N, V>
implements SubKeyedValueState<K, N, V> {
    private final SubKeyedValueStateDescriptor descriptor;
    private final StateStorage stateStorage;
    private AbstractInternalStateBackend internalStateBackend;
    private TypeSerializer<K> keySerializer;
    private TypeSerializer<N> namespaceSerializer;
    private TypeSerializer<V> valueSerializer;
    private final byte[] stateNameByte;
    private final byte[] stateNameForSerialize;
    private int serializedStateNameLength;
    ByteArrayOutputStreamWithPos outputStream = new ByteArrayOutputStreamWithPos();
    DataOutputView outputView = new DataOutputViewStreamWrapper((OutputStream)this.outputStream);
    protected final HashPartitioner partitioner = HashPartitioner.INSTANCE;

    public SubKeyedValueStateImpl(AbstractInternalStateBackend internalStateBackend, SubKeyedValueStateDescriptor descriptor, StateStorage stateStorage) {
        this.descriptor = (SubKeyedValueStateDescriptor)Preconditions.checkNotNull((Object)descriptor);
        this.stateStorage = (StateStorage)Preconditions.checkNotNull((Object)stateStorage);
        this.internalStateBackend = (AbstractInternalStateBackend)Preconditions.checkNotNull((Object)internalStateBackend);
        this.keySerializer = descriptor.getKeySerializer();
        this.namespaceSerializer = descriptor.getNamespaceSerializer();
        this.valueSerializer = descriptor.getValueSerializer();
        try {
            this.outputStream.reset();
            StringSerializer.INSTANCE.serialize(descriptor.getName(), this.outputView);
            this.stateNameByte = this.outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
        this.stateNameForSerialize = stateStorage.supportMultiColumnFamilies() ? null : this.stateNameByte;
        this.serializedStateNameLength = this.stateNameForSerialize == null ? 0 : this.stateNameForSerialize.length;
    }

    @Override
    public SubKeyedValueStateDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean contains(K key, N namespace) {
        if (key == null || namespace == null) {
            return false;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                return heapStateStorage.get(key) != null;
            }
            this.outputStream.reset();
            byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedValueState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            return this.stateStorage.get(serializedKey) != null;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public V get(K key, N namespace) {
        return this.getOrDefault(key, namespace, null);
    }

    @Override
    public V getOrDefault(K key, N namespace, V defaultValue) {
        if (key == null || namespace == null) {
            return defaultValue;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                Object value = heapStateStorage.get(key);
                return (V)(value == null ? defaultValue : value);
            }
            byte[] serializedValue = this.getSerializedValue(key, namespace, this.outputStream, this.outputView, this.keySerializer, this.namespaceSerializer);
            if (serializedValue == null) {
                return defaultValue;
            }
            return StateSerializerUtil.getDeserializeSingleValue(serializedValue, this.valueSerializer);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Map<N, V> getAll(K key) {
        if (key == null) {
            return Collections.emptyMap();
        }
        try {
            if (this.stateStorage.lazySerde()) {
                return ((HeapStateStorage)this.stateStorage).getAll(key);
            }
            HashMap<N, V> result = new HashMap<N, V>();
            this.outputStream.reset();
            byte[] prefix = StateSerializerUtil.getSerializedPrefixKeyForSubKeyedState(this.outputStream, this.outputView, key, this.keySerializer, null, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            StorageIterator iterator = this.stateStorage.prefixIterator(prefix);
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                byte[] byteKey = (byte[])pair.getKey();
                byte[] byteValue = (byte[])pair.getValue();
                N currentNamespace = StateSerializerUtil.getDeserializedNamespcae(byteKey, this.keySerializer, this.namespaceSerializer, this.stateStorage.supportMultiColumnFamilies() ? 0 : this.stateNameByte.length);
                V currentValue = StateSerializerUtil.getDeserializeSingleValue(byteValue, this.valueSerializer);
                result.put(currentNamespace, currentValue);
            }
            return result;
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void remove(K key, N namespace) {
        if (key == null || namespace == null) {
            return;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                heapStateStorage.remove(key);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedValueState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                this.stateStorage.remove(serializedKey);
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void removeAll(K key) {
        if (key == null) {
            return;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                ((HeapStateStorage)this.stateStorage).removeAll(key);
            } else {
                this.outputStream.reset();
                byte[] prefix = StateSerializerUtil.getSerializedPrefixKeyForSubKeyedState(this.outputStream, this.outputView, key, this.keySerializer, null, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                StorageIterator iterator = this.stateStorage.prefixIterator(prefix);
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    this.stateStorage.remove(pair.getKey());
                }
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public void put(K key, N namespace, V value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(namespace);
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                heapStateStorage.put(key, value);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedValueState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                this.outputStream.reset();
                this.valueSerializer.serialize(value, this.outputView);
                byte[] serializedValue = this.outputStream.toByteArray();
                this.stateStorage.put(serializedKey, serializedValue);
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public V getAndRemove(K key, N namespace) {
        if (key == null || namespace == null) {
            return null;
        }
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapSateStorage = (HeapStateStorage)this.stateStorage;
                heapSateStorage.setCurrentNamespace(namespace);
                return (V)heapSateStorage.getAndRemove(key);
            }
            this.outputStream.reset();
            byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedValueState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            byte[] serializedValue = (byte[])this.stateStorage.get(serializedKey);
            this.stateStorage.remove(serializedKey);
            return serializedValue == null ? null : (V)StateSerializerUtil.getDeserializeSingleValue(serializedValue, this.valueSerializer);
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Iterator<N> iterator(K key) {
        Preconditions.checkNotNull(key);
        try {
            if (this.stateStorage.lazySerde()) {
                return ((HeapStateStorage)this.stateStorage).namespaceIterator(key);
            }
            this.outputStream.reset();
            byte[] prefix = StateSerializerUtil.getSerializedPrefixKeyForSubKeyedState(this.outputStream, this.outputView, key, this.keySerializer, null, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
            final StorageIterator iterator = this.stateStorage.prefixIterator(prefix);
            return new Iterator<N>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public N next() {
                    try {
                        return StateSerializerUtil.getDeserializedNamespcae((byte[])((Pair)iterator.next()).getKey(), SubKeyedValueStateImpl.this.keySerializer, SubKeyedValueStateImpl.this.namespaceSerializer, SubKeyedValueStateImpl.this.stateStorage.supportMultiColumnFamilies() ? 0 : SubKeyedValueStateImpl.this.stateNameByte.length);
                    }
                    catch (IOException e) {
                        throw new StateAccessException(e);
                    }
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    @Override
    public Iterable<K> keys(N namespace) {
        Preconditions.checkNotNull(namespace, (String)"Do not support null as namespace.");
        Set<Object> keys = new HashSet();
        if (this.stateStorage.lazySerde()) {
            StateTable stateTable = ((HeapStateStorage)this.stateStorage).getStateTable();
            keys = stateTable.getKeys(namespace).collect(Collectors.toSet());
        } else {
            try {
                for (int group : this.internalStateBackend.getKeyGroupRange()) {
                    this.outputStream.reset();
                    StateSerializerUtil.serializeGroupPrefix(this.outputStream, group, this.stateNameForSerialize);
                    StorageIterator iterator = this.stateStorage.prefixIterator(this.outputStream.toByteArray());
                    while (iterator.hasNext()) {
                        Pair pair = (Pair)iterator.next();
                        Pair<K, N> keyAndNamespace = StateSerializerUtil.getDeserializedKeyAndNamespace((byte[])pair.getKey(), this.keySerializer, this.namespaceSerializer, this.serializedStateNameLength);
                        if (!namespace.equals(keyAndNamespace.getValue())) continue;
                        keys.add(keyAndNamespace.getKey());
                    }
                }
            }
            catch (Exception e) {
                throw new StateAccessException(e);
            }
        }
        return keys.isEmpty() ? null : keys;
    }

    @Override
    public StateStorage<K, V> getStateStorage() {
        return this.stateStorage;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<V> safeValueSerializer) throws Exception {
        Tuple2 keyAndNamespace = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, safeKeySerializer, safeNamespaceSerializer);
        if (this.stateStorage.lazySerde()) {
            V value = this.get(keyAndNamespace.f0, keyAndNamespace.f1);
            if (value == null) {
                return null;
            }
            return KvStateSerializer.serializeValue(value, safeValueSerializer);
        }
        ByteArrayOutputStreamWithPos baos = new ByteArrayOutputStreamWithPos();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)baos);
        return this.getSerializedValue(keyAndNamespace.f0, keyAndNamespace.f1, baos, (DataOutputView)view, safeKeySerializer, safeNamespaceSerializer);
    }

    private byte[] getSerializedValue(K key, N namespace, ByteArrayOutputStreamWithPos outputStream, DataOutputView outputView, TypeSerializer<K> keySerializer, TypeSerializer<N> safeNamespaceSerializer) throws Exception {
        outputStream.reset();
        byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedValueState(outputStream, outputView, key, keySerializer, namespace, safeNamespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
        return (byte[])this.stateStorage.get(serializedKey);
    }

    @Override
    public <T> void transform(K key, N namespace, T value, StateTransformationFunction<V, T> transformation) {
        try {
            if (this.stateStorage.lazySerde()) {
                HeapStateStorage heapStateStorage = (HeapStateStorage)this.stateStorage;
                heapStateStorage.setCurrentNamespace(namespace);
                heapStateStorage.transform(key, value, transformation);
            } else {
                this.outputStream.reset();
                byte[] serializedKey = StateSerializerUtil.getSerializedKeyForSubKeyedValueState(this.outputStream, this.outputView, key, this.keySerializer, namespace, this.namespaceSerializer, this.getKeyGroup(key), this.stateNameForSerialize);
                byte[] serializedValue = (byte[])this.stateStorage.get(serializedKey);
                Object oldValue = serializedValue == null ? null : (Object)StateSerializerUtil.getDeserializeSingleValue(serializedValue, this.valueSerializer);
                Object newValue = transformation.apply(oldValue, value);
                this.outputStream.reset();
                this.valueSerializer.serialize(newValue, this.outputView);
                this.stateStorage.put(serializedKey, this.outputStream.toByteArray());
            }
        }
        catch (Exception e) {
            throw new StateAccessException(e);
        }
    }

    private <K> int getKeyGroup(K key) {
        return this.partitioner.partition(key, this.internalStateBackend.getNumGroups());
    }
}

