/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.taskexecutor.JobManagerConnection;

public class JobManagerTable {
    private final Map<JobID, JobManagerConnection> jobIDIndices = new ConcurrentHashMap<JobID, JobManagerConnection>(4);
    private final Map<ResourceID, JobManagerConnection> resourceIDIndices = new ConcurrentHashMap<ResourceID, JobManagerConnection>(4);

    public Collection<JobManagerConnection> getAllJobManagerConnections() {
        return this.jobIDIndices.values();
    }

    public boolean contains(JobID jobId) {
        return this.jobIDIndices.containsKey(jobId);
    }

    public boolean add(JobManagerConnection jobManagerConnection) {
        JobManagerConnection previousJMC = this.jobIDIndices.put(jobManagerConnection.getJobID(), jobManagerConnection);
        if (previousJMC != null) {
            this.jobIDIndices.put(jobManagerConnection.getJobID(), previousJMC);
            return false;
        }
        this.resourceIDIndices.put(jobManagerConnection.getResourceID(), jobManagerConnection);
        return true;
    }

    public JobManagerConnection remove(JobID jobId) {
        JobManagerConnection jobManagerConnection = this.jobIDIndices.remove(jobId);
        if (jobManagerConnection != null) {
            this.resourceIDIndices.remove(jobManagerConnection.getResourceID());
        }
        return jobManagerConnection;
    }

    public JobManagerConnection get(JobID jobId) {
        return this.jobIDIndices.get(jobId);
    }

    public boolean contains(ResourceID resourceID) {
        return this.resourceIDIndices.containsKey(resourceID);
    }

    public JobManagerConnection remove(ResourceID resourceID) {
        JobManagerConnection jobManagerConnection = this.resourceIDIndices.remove(resourceID);
        if (jobManagerConnection != null) {
            this.jobIDIndices.remove(jobManagerConnection.getJobID());
        }
        return jobManagerConnection;
    }

    public JobManagerConnection get(ResourceID resourceID) {
        return this.resourceIDIndices.get(resourceID);
    }
}

